/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding.exi;

import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.main.api.sax.EXISource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xmlbeans.XmlObject;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.binding.SimpleBinding;
import org.n52.iceland.binding.exi.EXIUtils;
import org.n52.iceland.coding.decode.OwsDecodingException;
import org.n52.iceland.exception.HTTPException;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class EXIBinding
extends SimpleBinding {
    private static final Logger LOGGER = LoggerFactory.getLogger(EXIBinding.class);
    private static final Set<BindingKey> KEYS = Collections.singleton(new MediaTypeBindingKey(MediaTypes.APPLICATION_EXI));
    private final EXIUtils exiUtils;

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public EXIBinding(EXIUtils exiUtils) {
        this.exiUtils = exiUtils;
    }

    @Override
    protected MediaType getDefaultContentType() {
        return MediaTypes.APPLICATION_EXI;
    }

    @Override
    protected boolean isUseHttpResponseCodes() {
        return true;
    }

    @Override
    public boolean checkOperationHttpPostSupported(OwsOperationKey k) throws HTTPException {
        return this.hasDecoder(k, MediaTypes.TEXT_XML) || this.hasDecoder(k, MediaTypes.APPLICATION_XML);
    }

    @Override
    public void doPostOperation(HttpServletRequest req, HttpServletResponse res) throws HTTPException, IOException {
        OwsServiceRequest sosRequest = null;
        try {
            sosRequest = this.parseRequest(req);
            OwsServiceResponse sosResponse = this.getServiceOperator(sosRequest).receiveRequest(sosRequest);
            this.writeResponse(req, res, sosResponse);
        }
        catch (OwsExceptionReport oer) {
            oer.setVersion(sosRequest != null ? sosRequest.getVersion() : null);
            this.writeOwsExceptionReport(req, res, oer);
        }
    }

    protected OwsServiceRequest parseRequest(HttpServletRequest request) throws OwsExceptionReport {
        XmlObject doc = this.decode(request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EXI-REQUEST: {}", (Object)doc.xmlText());
        }
        Decoder decoder = this.getDecoder(CodingHelper.getDecoderKey((XmlObject)doc));
        try {
            return ((OwsServiceRequest)decoder.decode((Object)doc)).setRequestContext(this.getRequestContext(request));
        }
        catch (OwsDecodingException ex) {
            throw ex.getCause();
        }
        catch (DecodingException ex) {
            throw new InvalidParameterValueException().withMessage(ex.getMessage(), new Object[0]).causedBy((Throwable)ex).at((String)ex.getLocation().orElse(null));
        }
    }

    protected XmlObject decode(HttpServletRequest request) throws OwsExceptionReport {
        XmlObject xmlObject;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            EXIFactory ef = this.exiUtils.newEXIFactory();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (ef.isFragment()) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            EXISource exiSource = new EXISource(ef);
            XMLReader exiReader = exiSource.getXMLReader();
            exiReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            InputSource inputSource = new InputSource((InputStream)request.getInputStream());
            inputSource.setEncoding(request.getCharacterEncoding());
            SAXSource saxSource = new SAXSource(inputSource);
            saxSource.setXMLReader(exiReader);
            transformer.transform(saxSource, new StreamResult(os));
            xmlObject = XmlHelper.parseXmlString((String)os.toString(StandardCharsets.UTF_8.name()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (EXIException | IOException | SAXNotRecognizedException | SAXNotSupportedException ex) {
                throw new NoApplicableCodeException().causedBy(ex).withMessage("Error while reading request! Message: %s", new Object[]{ex.getMessage()});
            }
            catch (TransformerException ex) {
                throw new NoApplicableCodeException().causedBy((Throwable)ex).withMessage("Error while transforming request! Message: %s", new Object[]{ex.getMessage()});
            }
            catch (DecodingException ex) {
                throw new NoApplicableCodeException().causedBy((Throwable)ex).withMessage("Error while parsing request! Message: %s", new Object[]{ex.getMessage()});
            }
        }
        os.close();
        return xmlObject;
    }

    public Set<BindingKey> getKeys() {
        return Collections.unmodifiableSet(KEYS);
    }
}

