/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util.activation;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.n52.iceland.util.activation.Activatables;

public class Activatable<T> {
    private T object;
    private boolean active;

    public Activatable(T object) {
        this(object, true);
    }

    public Activatable(T object, boolean active) {
        this.object = object;
        this.active = active;
    }

    public T get() {
        return this.isActive() ? (T)this.getInternal() : null;
    }

    public Optional<T> getOptional() {
        return Optional.ofNullable(this.get());
    }

    public T getInternal() {
        return this.object;
    }

    public boolean isActive() {
        return this.active;
    }

    public Activatable<T> setActive(boolean active) {
        this.active = active;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.getInternal(), this.isActive());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Activatable) {
            Activatable a = (Activatable)obj;
            return Objects.equals(this.isActive(), a.isActive()) && Objects.equals(this.getInternal(), a.getInternal());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("object", this.getInternal()).add("active", this.isActive()).toString();
    }

    public static <K, V> Map<K, V> filter(Map<K, Activatable<V>> map) {
        return Activatables.filter(map);
    }

    public static <E> Set<E> filter(Set<Activatable<E>> set) {
        return Activatables.filter(set);
    }

    public static <E> Set<E> unfiltered(Set<Activatable<E>> set) {
        return Activatables.unfiltered(set);
    }

    public static <K, V> Map<K, V> unfiltered(Map<K, Activatable<V>> map) {
        return Activatables.unfiltered(map);
    }

    public static <E> Set<Activatable<E>> from(Set<E> set) {
        return Activatables.from(set);
    }

    public static <T> Activatable<T> from(T t) {
        return Activatables.from(t);
    }

    public static <T> Activatable<T> from(T t, boolean active) {
        return Activatables.from(t, active);
    }
}

