/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Locale;
import org.n52.faroe.ConfigurationError;
import org.n52.iceland.util.LazyThreadSafeProducer;
import org.n52.iceland.util.LocalizedProducer;

public abstract class LocalizedLazyThreadSafeProducer<T>
extends LazyThreadSafeProducer<T>
implements LocalizedProducer<T> {
    private final LoadingCache<Locale, T> cache = CacheBuilder.newBuilder().build(new CacheLoader<Locale, T>(){

        public T load(Locale key) {
            return LocalizedLazyThreadSafeProducer.this.create(key);
        }
    });
    private T t;

    @Override
    protected void setRecreate() {
        super.setRecreate();
        this.cache.invalidateAll();
    }

    @Override
    public T get(Locale language) throws ConfigurationError {
        if (language == null) {
            return this.get();
        }
        try {
            return (T)this.cache.getUnchecked((Object)language);
        }
        catch (UncheckedExecutionException ex) {
            if (ex.getCause() instanceof ConfigurationError) {
                throw (ConfigurationError)ex.getCause();
            }
            throw ex;
        }
    }

    @Override
    protected T create() throws ConfigurationError {
        return this.create(null);
    }

    protected abstract T create(Locale var1) throws ConfigurationError;
}

