/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.service;

import java.util.Collections;
import java.util.Set;
import org.n52.iceland.event.events.ExceptionEvent;
import org.n52.janmayen.event.Event;
import org.n52.janmayen.event.EventListener;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionLogger
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionLogger.class);
    private static final String MESSAGE = "Exception thrown";

    public Set<Class<? extends Event>> getTypes() {
        return Collections.singleton(ExceptionEvent.class);
    }

    public void handle(Event event) {
        ExceptionEvent ee = (ExceptionEvent)event;
        if (ee.getException() instanceof OwsExceptionReport) {
            OwsExceptionReport owse = (OwsExceptionReport)((Object)ee.getException());
            if (owse.getStatus() == null) {
                this.log(owse);
            } else if (owse.getStatus().getCode() >= 500) {
                LOGGER.error(MESSAGE, (Throwable)owse);
            } else if (owse.getStatus().getCode() >= 400) {
                LOGGER.warn(MESSAGE, (Throwable)owse);
            } else {
                this.log(owse);
            }
        } else {
            LOGGER.debug("Error processing request", (Throwable)ee.getException());
        }
    }

    private void log(OwsExceptionReport owse) {
        LOGGER.debug(MESSAGE, (Throwable)owse);
    }
}

