/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.response;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.n52.iceland.service.CommunicationObjectWithSoapHeader;
import org.n52.janmayen.http.HTTPStatus;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.w3c.soap.SoapHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResponse
implements CommunicationObjectWithSoapHeader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceResponse.class);
    private final ByteArrayOutputStream byteArrayOutputStream;
    private HTTPStatus status;
    private MediaType contentType;
    private boolean supportsGZip = true;
    private final Map<String, String> headerMap = Maps.newHashMap();
    private final List<SoapHeader> soapHeaderMap = Lists.newArrayList();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ServiceResponse(ByteArrayOutputStream baos, MediaType contentType, HTTPStatus status) {
        this.byteArrayOutputStream = baos;
        this.contentType = contentType;
        this.status = status;
    }

    public ServiceResponse(ByteArrayOutputStream baos, MediaType contentType) {
        this(baos, contentType, null);
    }

    public ServiceResponse(MediaType contentType, HTTPStatus status) {
        this(null, contentType, status);
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public boolean isSetHeaderMap() {
        return !this.headerMap.isEmpty();
    }

    public void setHeader(String headerIdentifier, String headerValue) {
        this.headerMap.put(headerIdentifier, headerValue);
    }

    public Map<String, String> getHeaderMap() {
        return Collections.unmodifiableMap(this.headerMap);
    }

    public void writeToOutputStream(OutputStream outputStream) {
        if (this.byteArrayOutputStream == null) {
            LOGGER.error("no response to write to.");
            return;
        }
        try {
            this.byteArrayOutputStream.writeTo(outputStream);
            this.byteArrayOutputStream.flush();
        }
        catch (IOException ioe) {
            LOGGER.error("doResponse", (Throwable)ioe);
        }
        finally {
            try {
                this.byteArrayOutputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.error("doSoapResponse, close streams", (Throwable)ioe);
            }
        }
    }

    public boolean isContentLess() {
        return this.byteArrayOutputStream == null;
    }

    public int getContentLength() {
        return this.byteArrayOutputStream == null ? -1 : this.byteArrayOutputStream.toByteArray().length;
    }

    public HTTPStatus getStatus() {
        return this.status != null ? this.status : (this.isContentLess() ? HTTPStatus.NO_CONTENT : HTTPStatus.OK);
    }

    public void setStatus(HTTPStatus status) {
        this.status = status;
    }

    public String toString() {
        return String.format("ServiceResponse [byteArrayOutputStream=%s, httpResponseCode=%s, contentType=%s, headerMap=%s]", this.byteArrayOutputStream, this.status, this.contentType, this.headerMap);
    }

    @Override
    public List<SoapHeader> getSoapHeader() {
        return Collections.unmodifiableList(this.soapHeaderMap);
    }

    @Override
    public void setSoapHeader(List<SoapHeader> header) {
        this.soapHeaderMap.clear();
        if (header != null) {
            this.soapHeaderMap.addAll(header);
        }
    }

    @Override
    public boolean isSetSoapHeader() {
        return !this.soapHeaderMap.isEmpty();
    }

    public boolean supportsGZip() {
        return this.supportsGZip;
    }

    public void setSupportsGZip(boolean supportsGZip) {
        this.supportsGZip = supportsGZip;
    }
}

