/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.request.operator;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.n52.iceland.convert.RequestResponseModifier;
import org.n52.iceland.convert.RequestResponseModifierRepository;
import org.n52.iceland.event.events.RequestEvent;
import org.n52.iceland.event.events.ResponseEvent;
import org.n52.iceland.request.handler.GenericOperationHandler;
import org.n52.iceland.request.handler.OperationHandlerRepository;
import org.n52.iceland.request.operator.ParameterValidator;
import org.n52.iceland.request.operator.RequestOperator;
import org.n52.iceland.request.operator.RequestOperatorKey;
import org.n52.iceland.service.operator.ServiceOperatorRepository;
import org.n52.janmayen.event.Event;
import org.n52.janmayen.event.EventBus;
import org.n52.shetland.ogc.ows.OwsOperation;
import org.n52.shetland.ogc.ows.exception.OperationNotSupportedException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRequestOperator<Q extends OwsServiceRequest, A extends OwsServiceResponse>
implements RequestOperator {
    private static final Logger LOG = LoggerFactory.getLogger(GenericRequestOperator.class);
    private ParameterValidator<Q> validator;
    private RequestOperatorKey requestOperatorKey;
    private Class<Q> requestType;
    private OperationHandlerRepository operationHandlerRepository;
    private RequestResponseModifierRepository modifierRepository;
    private ServiceOperatorRepository serviceOperatorRepository;
    private EventBus eventBus;

    public GenericRequestOperator(String service, String version, String operation, Class<Q> requestType, ParameterValidator<Q> validator) {
        this(new OwsOperationKey(service, version, operation), true, requestType, validator);
    }

    public GenericRequestOperator(OwsOperationKey operation, Class<Q> requestType, ParameterValidator<Q> validator) {
        this(operation, true, requestType, validator);
    }

    public GenericRequestOperator(OwsOperationKey operation, boolean defaultActive, Class<Q> requestType, ParameterValidator<Q> validator) {
        this.requestOperatorKey = new RequestOperatorKey(operation.getService(), operation.getVersion(), operation.getOperation(), defaultActive);
        this.requestType = Objects.requireNonNull(requestType, "requestType");
        this.validator = Objects.requireNonNull(validator, "checker");
        LOG.info("{} initialized successfully for {}!", (Object)this.getClass().getSimpleName(), (Object)this.requestOperatorKey);
    }

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setOperationHandlerRepository(OperationHandlerRepository repo) {
        this.operationHandlerRepository = repo;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public OperationHandlerRepository getOperationHandlerRepository() {
        return this.operationHandlerRepository;
    }

    @Inject
    public void setRequestResponseModifierRepository(RequestResponseModifierRepository repo) {
        this.modifierRepository = repo;
    }

    public RequestResponseModifierRepository getRequestResponseModifierRepository() {
        return this.modifierRepository;
    }

    @Inject
    public void setServiceOperatorRepository(ServiceOperatorRepository repo) {
        this.serviceOperatorRepository = repo;
    }

    public ServiceOperatorRepository getServiceOperatorRepository() {
        return this.serviceOperatorRepository;
    }

    @Inject
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    private void checkForModifierAndProcess(OwsServiceRequest request) throws OwsExceptionReport {
        if (!this.modifierRepository.hasRequestResponseModifier(request)) {
            return;
        }
        LinkedList splitter = new LinkedList();
        LinkedList remover = new LinkedList();
        LinkedList defaultModifier = new LinkedList();
        this.modifierRepository.getRequestResponseModifier(request).stream().forEach(modifier -> {
            if (modifier.getFacilitator().isSplitter()) {
                splitter.add(modifier);
            } else if (modifier.getFacilitator().isAdderRemover()) {
                remover.add(modifier);
            } else {
                defaultModifier.add(modifier);
            }
        });
        for (RequestResponseModifier modifier2 : remover) {
            modifier2.modifyRequest(request);
        }
        for (RequestResponseModifier modifier2 : defaultModifier) {
            modifier2.modifyRequest(request);
        }
        for (RequestResponseModifier modifier2 : splitter) {
            modifier2.modifyRequest(request);
        }
    }

    private void checkForModifierAndProcess(OwsServiceRequest request, OwsServiceResponse response) throws OwsExceptionReport {
        if (!this.modifierRepository.hasRequestResponseModifier(request, response)) {
            return;
        }
        LinkedList defaultModifier = new LinkedList();
        LinkedList remover = new LinkedList();
        LinkedList merger = new LinkedList();
        this.modifierRepository.getRequestResponseModifier(request, response).stream().forEach(modifier -> {
            if (modifier.getFacilitator().isMerger()) {
                merger.add(modifier);
            } else if (modifier.getFacilitator().isAdderRemover()) {
                remover.add(modifier);
            } else {
                defaultModifier.add(modifier);
            }
        });
        for (RequestResponseModifier modifier2 : merger) {
            modifier2.modifyResponse(request, response);
        }
        for (RequestResponseModifier modifier2 : defaultModifier) {
            modifier2.modifyResponse(request, response);
        }
        for (RequestResponseModifier modifier2 : remover) {
            modifier2.modifyResponse(request, response);
        }
    }

    @Override
    public OwsServiceResponse receiveRequest(OwsServiceRequest abstractRequest) throws OwsExceptionReport {
        this.eventBus.submit((Event)new RequestEvent(abstractRequest));
        if (this.requestType.isAssignableFrom(abstractRequest.getClass())) {
            OwsServiceRequest request = (OwsServiceRequest)this.requestType.cast(abstractRequest);
            this.checkForModifierAndProcess(request);
            this.validator.validate(request);
            A response = this.receive(request);
            this.eventBus.submit((Event)new ResponseEvent((OwsServiceResponse)response));
            this.checkForModifierAndProcess(request, (OwsServiceResponse)response);
            return response;
        }
        throw new OperationNotSupportedException(abstractRequest.getOperationName());
    }

    protected GenericOperationHandler<Q, A> getOperationHandler() {
        return this.getOptionalOperationHandler().orElseThrow(() -> {
            String message = String.format("OperationHandler for Operation %s has no implementation!", this.requestOperatorKey.getOperationName());
            return new NullPointerException(message);
        });
    }

    protected Optional<GenericOperationHandler<Q, A>> getOptionalOperationHandler() {
        String service = this.requestOperatorKey.getService();
        String operationName = this.requestOperatorKey.getOperationName();
        return this.getOptionalOperationHandler(service, operationName);
    }

    protected Optional<GenericOperationHandler<Q, A>> getOptionalOperationHandler(String service, String operationName) {
        return Optional.ofNullable(this.operationHandlerRepository.getOperationHandler(service, operationName)).map(x -> (GenericOperationHandler)x);
    }

    @Override
    public OwsOperation getOperationMetadata(String service, String version) throws OwsExceptionReport {
        Optional<GenericOperationHandler<Q, A>> optionalOperationHandler = this.getOptionalOperationHandler();
        if (optionalOperationHandler.isPresent()) {
            return optionalOperationHandler.get().getOperationsMetadata(service, version);
        }
        return null;
    }

    protected String getOperationName() {
        return this.requestOperatorKey.getOperationName();
    }

    public Set<RequestOperatorKey> getKeys() {
        return Collections.singleton(this.requestOperatorKey);
    }

    protected A receive(Q request) throws OwsExceptionReport {
        return this.getOperationHandler().handle(request);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.requestOperatorKey).toString();
    }
}

