/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.request.handler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.binding.Binding;
import org.n52.iceland.binding.BindingRepository;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.binding.PathBindingKey;
import org.n52.iceland.exception.HTTPException;
import org.n52.iceland.request.handler.OperationHandler;
import org.n52.janmayen.function.Functions;
import org.n52.janmayen.http.HTTPMethods;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsDCP;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.ogc.ows.OwsHttp;
import org.n52.shetland.ogc.ows.OwsMetadata;
import org.n52.shetland.ogc.ows.OwsOperation;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsRequestMethod;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;

@Configurable
public abstract class AbstractOperationHandler
implements OperationHandler {
    private URI serviceURL;
    private BindingRepository bindingRepository;
    private Locale defaultLanguage = Locale.ENGLISH;
    private boolean showAllLanguages;

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setBindingRepository(BindingRepository bindingRepository) {
        this.bindingRepository = Objects.requireNonNull(bindingRepository);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public BindingRepository getBindingRepository() {
        return this.bindingRepository;
    }

    @Setting(value="service.serviceURL")
    public void setServiceURL(URI serviceURL) throws ConfigurationError {
        this.setURL(serviceURL);
    }

    public void setURL(URI serviceURL) throws ConfigurationError {
        this.serviceURL = (URI)Validation.notNull((String)"Service URL", (Object)serviceURL);
    }

    protected URI getServiceURL() {
        return this.serviceURL;
    }

    @Setting(value="i18n.defaultLanguage", required=false)
    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = LocaleHelper.decode((String)defaultLanguage);
    }

    protected Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Setting(value="i18n.showAllLanguageValues", required=false)
    public void setShowAllLanguages(boolean showAllLanguages) {
        this.showAllLanguages = showAllLanguages;
    }

    protected boolean isShowAllLanguages() {
        return this.showAllLanguages;
    }

    protected Locale getRequestedLocale(OwsServiceRequest request) {
        return LocaleHelper.decode((String)request.getRequestedLanguage(), (Locale)this.defaultLanguage);
    }

    private Set<OwsDCP> getDCP(String service, String version) {
        return Collections.singleton(this.getDCP(new OwsOperationKey(service, version, this.getOperationName())));
    }

    private OwsDCP getDCP(OwsOperationKey operation) {
        Set methods = Stream.concat(this.getRequestMethodsForServiceURL(operation), this.getRequestMethodsForBindingURL(operation)).collect(Collectors.toSet());
        return new OwsHttp(methods);
    }

    private Stream<OwsRequestMethod> getRequestMethodsForBindingURL(OwsOperationKey operation) {
        return this.bindingRepository.getBindings().values().stream().flatMap(Functions.currySecond(this::getRequestMethods, (Object)operation));
    }

    private Stream<OwsRequestMethod> getRequestMethodsForServiceURL(OwsOperationKey operation) {
        HashMap mediaTypesByMethod = new HashMap(HTTPMethods.METHODS.size());
        this.bindingRepository.getBindings().values().stream().forEach(binding -> HTTPMethods.METHODS.stream().filter(this.isMethodSupported((Binding)binding, operation)).forEach(method -> ((Set)mediaTypesByMethod.computeIfAbsent(method, Functions.forSupplier(HashSet::new))).addAll(this.getMediaTypes((Binding)binding))));
        return mediaTypesByMethod.entrySet().stream().map(e -> new OwsRequestMethod(this.serviceURL, (String)e.getKey(), this.createContentTypeDomains((Set)e.getValue())));
    }

    private Set<OwsValue> getMediaTypes(Binding binding) {
        return binding.getKeys().stream().map(Functions.castIfInstanceOf(MediaTypeBindingKey.class)).filter(Optional::isPresent).map(Optional::get).map(MediaTypeBindingKey::getMediaType).map(MediaType::toString).map(OwsValue::new).collect(Collectors.toSet());
    }

    private Set<OwsDomain> createContentTypeDomains(Set<OwsValue> value) {
        return Collections.singleton(this.createContentTypeDomain(value));
    }

    private OwsDomain createContentTypeDomain(Set<OwsValue> value) {
        return new OwsDomain("Content-Type", (OwsPossibleValues)new OwsAllowedValues(value));
    }

    private Stream<OwsRequestMethod> getRequestMethods(Binding binding, OwsOperationKey operation) {
        Set<OwsDomain> constraints = this.createContentTypeDomains(this.getMediaTypes(binding));
        return binding.getKeys().stream().map(Functions.castIfInstanceOf(PathBindingKey.class)).filter(Optional::isPresent).map(Optional::get).map(PathBindingKey::getPath).map(path -> URI.create(this.serviceURL + path)).flatMap(uri -> HTTPMethods.METHODS.stream().filter(this.isMethodSupported(binding, operation)).map(method -> new OwsRequestMethod(uri, method, (Collection)constraints)));
    }

    private Predicate<String> isMethodSupported(Binding binding, OwsOperationKey operation) {
        return method -> this.isMethodSupported(binding, (String)method, operation);
    }

    private boolean isMethodSupported(Binding binding, String method, OwsOperationKey operation) {
        try {
            switch (method) {
                case "GET": {
                    return binding.checkOperationHttpGetSupported(operation);
                }
                case "POST": {
                    return binding.checkOperationHttpPostSupported(operation);
                }
                case "PUT": {
                    return binding.checkOperationHttpPutSupported(operation);
                }
                case "DELETE": {
                    return binding.checkOperationHttpDeleteSupported(operation);
                }
            }
            return false;
        }
        catch (HTTPException ignored) {
            return false;
        }
    }

    @Override
    public OwsOperation getOperationsMetadata(String service, String version) throws OwsExceptionReport {
        String name = this.getOperationName();
        Set<OwsDomain> parameters = this.getOperationParameters(service, version);
        Set<OwsDomain> constraints = this.getOperationConstraints(service, version);
        Set<OwsMetadata> metadata = this.getOperationMetadata(service, version);
        Set<OwsDCP> dcp = this.getDCP(service, version);
        return new OwsOperation(name, parameters, constraints, metadata, dcp);
    }

    protected Set<OwsDomain> getOperationParameters(String service, String version) throws OwsExceptionReport {
        return null;
    }

    protected Set<OwsDomain> getOperationConstraints(String service, String version) throws OwsExceptionReport {
        return null;
    }

    protected Set<OwsMetadata> getOperationMetadata(String service, String version) throws OwsExceptionReport {
        return null;
    }
}

