/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.i18n.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.n52.iceland.exception.JSONException;
import org.n52.iceland.i18n.metadata.AbstractI18NMetadata;
import org.n52.iceland.i18n.metadata.I18NFeatureMetadata;
import org.n52.iceland.i18n.metadata.I18NObservablePropertyMetadata;
import org.n52.iceland.i18n.metadata.I18NOfferingMetadata;
import org.n52.iceland.i18n.metadata.I18NProcedureMetadata;
import org.n52.janmayen.Json;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.janmayen.i18n.LocalizedString;
import org.n52.janmayen.i18n.MultilingualString;

public class I18NJsonEncoder {
    private static final String DESCRIPTION = "description";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String LONG_NAME = "longName";
    private static final String SHORT_NAME = "shortName";
    private static final String TYPE = "type";
    private static final String TYPE_FEATURE = "feature";
    private static final String TYPE_OFFERING = "offering";
    private static final String TYPE_PROCEDURE = "procedure";
    private static final String TYPE_OBSERVABLE_PROPERTY = "observableProperty";
    private static final String I18N = "i18n";
    private final JsonNodeFactory nodeFactory = Json.nodeFactory();

    private ObjectNode encodeInternal(AbstractI18NMetadata i18n) {
        ObjectNode node = this.nodeFactory.objectNode();
        node.put(ID, i18n.getIdentifier());
        node.set(NAME, (JsonNode)this.encode(i18n.getName()));
        node.set(DESCRIPTION, (JsonNode)this.encode(i18n.getDescription()));
        return node;
    }

    public ObjectNode encode(MultilingualString mls) {
        ObjectNode json = this.nodeFactory.objectNode();
        if (mls != null) {
            for (LocalizedString ls : mls) {
                json.put(LocaleHelper.encode((Locale)ls.getLang()), ls.getText());
            }
        }
        return json;
    }

    public ObjectNode encode(I18NFeatureMetadata i18n) {
        return this.encodeInternal(i18n).put(TYPE, TYPE_FEATURE);
    }

    public ObjectNode encode(I18NObservablePropertyMetadata i18n) {
        return this.encodeInternal(i18n).put(TYPE, TYPE_OBSERVABLE_PROPERTY);
    }

    public ObjectNode encode(I18NOfferingMetadata i18n) {
        return this.encodeInternal(i18n).put(TYPE, TYPE_OFFERING);
    }

    public ObjectNode encode(I18NProcedureMetadata i18n) {
        ObjectNode node = this.encodeInternal(i18n);
        node.set(SHORT_NAME, (JsonNode)this.encode(i18n.getShortName()));
        node.set(LONG_NAME, (JsonNode)this.encode(i18n.getLongName()));
        node.put(TYPE, TYPE_PROCEDURE);
        return node;
    }

    public ObjectNode encode(Iterable<? extends AbstractI18NMetadata> i18ns) throws JSONException {
        ObjectNode node = this.nodeFactory.objectNode();
        ArrayNode array = node.putArray(I18N);
        for (AbstractI18NMetadata abstractI18NMetadata : i18ns) {
            array.add((JsonNode)this.encode(abstractI18NMetadata));
        }
        return node;
    }

    public ObjectNode encode(AbstractI18NMetadata i18n) throws JSONException {
        if (i18n instanceof I18NFeatureMetadata) {
            return this.encode((I18NFeatureMetadata)i18n);
        }
        if (i18n instanceof I18NOfferingMetadata) {
            return this.encode((I18NOfferingMetadata)i18n);
        }
        if (i18n instanceof I18NProcedureMetadata) {
            return this.encode((I18NProcedureMetadata)i18n);
        }
        if (i18n instanceof I18NObservablePropertyMetadata) {
            return this.encode((I18NObservablePropertyMetadata)i18n);
        }
        throw new JSONException("Unknown metadata type: " + i18n);
    }

    public MultilingualString decodeMultilingualString(JsonNode json) {
        MultilingualString mls = new MultilingualString();
        this.decodeMultilingualString(json, mls);
        return mls;
    }

    private void decodeMultilingualString(JsonNode json, MultilingualString mls) {
        Iterator it = json.fields();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            Locale locale = LocaleHelper.decode((String)((String)e.getKey()));
            mls.addLocalization(locale, ((JsonNode)e.getValue()).asText());
        }
    }

    public AbstractI18NMetadata decodeI18NMetadata(JsonNode s) throws JSONException {
        AbstractI18NMetadata i18n;
        String type = s.path(TYPE).asText();
        String id = s.path(ID).asText();
        if (type.equals(TYPE_FEATURE)) {
            i18n = new I18NFeatureMetadata(id);
        } else if (type.equals(TYPE_OBSERVABLE_PROPERTY)) {
            i18n = new I18NObservablePropertyMetadata(id);
        } else if (type.equals(TYPE_OFFERING)) {
            i18n = new I18NOfferingMetadata(id);
        } else if (type.equals(TYPE_PROCEDURE)) {
            I18NProcedureMetadata pi18n = new I18NProcedureMetadata(id);
            this.decodeMultilingualString(s.path(LONG_NAME), pi18n.getLongName());
            this.decodeMultilingualString(s.path(SHORT_NAME), pi18n.getShortName());
            i18n = pi18n;
        } else {
            throw new JSONException("Unknown type: " + type);
        }
        this.decodeMultilingualString(s.path(NAME), i18n.getName());
        this.decodeMultilingualString(s.path(DESCRIPTION), i18n.getDescription());
        return i18n;
    }
}

