/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.config.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.n52.faroe.json.AbstractJsonDao;
import org.n52.iceland.ogc.AbstractComparableServiceVersionDomainKey;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;

public abstract class AbstractJsonActivationDao
extends AbstractJsonDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive(String path, Predicate<JsonNode> matcher, boolean defaultValue) {
        this.readLock().lock();
        try {
            JsonNode array = this.getConfiguration().path("activation").path(path);
            boolean bl = this.createStream(array).filter(matcher).findAny().orElseGet(MissingNode::getInstance).path("active").asBoolean(defaultValue);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(String path, Predicate<JsonNode> matcher, Function<Supplier<ObjectNode>, Supplier<ObjectNode>> encoder, boolean active) {
        this.writeLock().lock();
        try {
            ArrayNode array = this.getConfiguration().with("activation").withArray(path);
            ObjectNode node = this.createStream((JsonNode)array).filter(matcher).findAny().orElseGet(encoder.apply(() -> ((ArrayNode)array).addObject()));
            node.put("active", active);
        }
        finally {
            this.writeLock().unlock();
        }
        this.configuration().scheduleWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K> Set<K> getKeys(String path, Function<JsonNode, K> decoder) {
        this.readLock().lock();
        try {
            JsonNode array = this.getConfiguration().path("activation").path(path);
            Set set = this.createStream(array).map(decoder).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.readLock().unlock();
        }
    }

    protected Predicate<JsonNode> matches(AbstractComparableServiceVersionDomainKey<?> key) {
        OwsServiceKey sok = key == null ? null : key.getServiceOperatorKey();
        String domain = key == null ? null : key.getDomain();
        return this.matches(sok).and(this.matchesDomain(domain));
    }

    protected Predicate<JsonNode> matches(OwsServiceKey key) {
        String service = key == null ? null : key.getService();
        String version = key == null ? null : key.getVersion();
        return this.matchesService(service).and(this.matchesVersion(version));
    }

    protected Predicate<JsonNode> matchesDomain(String domain) {
        if (domain == null) {
            return this.isNullOrMissing("domain");
        }
        return n -> n.path("domain").asText().equals(domain);
    }

    protected Predicate<JsonNode> matchesService(String service) {
        if (service == null) {
            return this.isNullOrMissing("service");
        }
        return n -> n.path("service").asText().equals(service);
    }

    protected Predicate<JsonNode> matchesVersion(String version) {
        if (version == null) {
            return this.isNullOrMissing("version");
        }
        return n -> n.path("version").asText().equals(version);
    }

    protected Supplier<ObjectNode> encode(Supplier<ObjectNode> supplier, AbstractComparableServiceVersionDomainKey<?> key) {
        Objects.requireNonNull(supplier);
        return () -> {
            OwsServiceKey sok = key == null ? null : key.getServiceOperatorKey();
            String domain = key == null ? null : key.getDomain();
            return this.encode(supplier, sok).get().put("domain", domain);
        };
    }

    protected Supplier<ObjectNode> encode(Supplier<ObjectNode> supplier, OwsServiceKey key) {
        Objects.requireNonNull(supplier);
        return () -> {
            String service = key == null ? null : key.getService();
            String version = key == null ? null : key.getVersion();
            return ((ObjectNode)supplier.get()).put("service", service).put("version", version);
        };
    }

    protected <K extends AbstractComparableServiceVersionDomainKey<K>> Function<JsonNode, K> createDomainDecoder(BiFunction<OwsServiceKey, String, K> fun) {
        Objects.requireNonNull(fun);
        return n -> (AbstractComparableServiceVersionDomainKey)fun.apply(this.decodeServiceOperatorKey((JsonNode)n), n.path("domain").textValue());
    }

    protected OwsServiceKey decodeServiceOperatorKey(JsonNode node) {
        return new OwsServiceKey(node.path("service").textValue(), node.path("version").textValue());
    }
}

