/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Set;
import javax.inject.Inject;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.config.ActivationDao;
import org.n52.iceland.ogc.ows.extension.OwsOperationMetadataExtensionProviderKey;
import org.n52.iceland.request.operator.RequestOperatorKey;
import org.n52.iceland.util.activation.ActivationInitializer;
import org.n52.iceland.util.activation.ActivationSource;
import org.n52.iceland.util.activation.DefaultActivationInitializer;
import org.n52.iceland.util.activation.FunctionalActivationListener;

public class ActivationService {
    private ActivationDao activationDao;

    @Inject
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void setActivationDao(ActivationDao dao) {
        this.activationDao = dao;
    }

    protected ActivationDao getActivationDao() {
        return this.activationDao;
    }

    public boolean isBindingActive(BindingKey key) {
        return this.getActivationDao().isBindingActive(key);
    }

    public boolean isOwsOperationMetadataExtensionProviderActive(OwsOperationMetadataExtensionProviderKey key) {
        return this.getActivationDao().isOwsOperationMetadataExtensionProviderActive(key);
    }

    public boolean isRequestOperatorActive(RequestOperatorKey key) {
        return this.getActivationDao().isRequestOperatorActive(key);
    }

    public FunctionalActivationListener<RequestOperatorKey> getRequestOperatorListener() {
        return this.getActivationDao()::setOperationStatus;
    }

    public ActivationSource<RequestOperatorKey> getRequestOperatorSource() {
        return ActivationSource.create(this::isRequestOperatorActive, this::getRequestOperatorKeys);
    }

    public Set<RequestOperatorKey> getRequestOperatorKeys() {
        return this.getActivationDao().getRequestOperatorKeys();
    }

    public ActivationInitializer<RequestOperatorKey> getRequestOperatorInitializer() {
        return new DefaultActivationInitializer<RequestOperatorKey>(this.getRequestOperatorSource());
    }

    public FunctionalActivationListener<BindingKey> getBindingListener() {
        return this.getActivationDao()::setBindingStatus;
    }

    public ActivationSource<BindingKey> getBindingSource() {
        return ActivationSource.create(this::isBindingActive, this::getBindingKeys);
    }

    public Set<BindingKey> getBindingKeys() {
        return this.getActivationDao().getBindingKeys();
    }

    public ActivationInitializer<BindingKey> getBindingInitializer() {
        return new DefaultActivationInitializer<BindingKey>(this.getBindingSource());
    }

    public FunctionalActivationListener<OwsOperationMetadataExtensionProviderKey> getOwsOperationMetadataExtensionProviderListener() {
        return this.getActivationDao()::setOwsOperationMetadataExtensionProviderStatus;
    }

    public ActivationSource<OwsOperationMetadataExtensionProviderKey> getOwsOperationMetadataExtensionProviderSource() {
        return ActivationSource.create(this::isOwsOperationMetadataExtensionProviderActive, this::getOwsOperationMetadataExtensionProviderKeys);
    }

    public Set<OwsOperationMetadataExtensionProviderKey> getOwsOperationMetadataExtensionProviderKeys() {
        return this.getActivationDao().getOwsOperationMetadataExtensionProviderKeys();
    }

    public ActivationInitializer<OwsOperationMetadataExtensionProviderKey> getOwsOperationMetadataExtensionProviderInitializer() {
        return new DefaultActivationInitializer<OwsOperationMetadataExtensionProviderKey>(this.getOwsOperationMetadataExtensionProviderSource());
    }
}

