/*
 * Copyright (C) 2015-2022 52°North Spatial Information Research GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.iceland.service;

import java.io.File;

import javax.inject.Inject;
import javax.servlet.ServletContext;

import org.n52.janmayen.ConfigLocationProvider;

public class ServletConfigLocationProvider implements ConfigLocationProvider {
    private static final String RELATIVE_PATH = "/";

    private String path;

    @Override
    public String get() {
        return this.path;
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        String relativePath = servletContext.getRealPath(RELATIVE_PATH);
        this.path = new File(relativePath).getAbsolutePath();
    }

}
