/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.config.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Set;
import org.n52.faroe.json.AbstractJsonDao;
import org.n52.iceland.config.AdminUserDao;
import org.n52.iceland.config.AdministratorUser;
import org.n52.iceland.config.json.JsonAdministratorUser;

public class JsonAdminUserDao
extends AbstractJsonDao
implements AdminUserDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdministratorUser createAdminUser(String username, String password) {
        JsonAdministratorUser user;
        this.configuration().writeLock().lock();
        try {
            user = new JsonAdministratorUser(username, password);
            this.saveAdminUser(user);
        }
        finally {
            this.configuration().writeLock().unlock();
        }
        this.configuration().scheduleWrite();
        return user;
    }

    @Override
    public void deleteAdminUser(String username) {
        this.configuration().writeLock().lock();
        try {
            this.getConfiguration().with("users").remove(username);
            this.configuration().scheduleWrite();
        }
        finally {
            this.configuration().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdministratorUser getAdminUser(String username) {
        this.configuration().readLock().lock();
        try {
            String password = this.getConfiguration().path("users").path(username).asText(null);
            JsonAdministratorUser jsonAdministratorUser = password == null ? null : new JsonAdministratorUser(username, password);
            return jsonAdministratorUser;
        }
        finally {
            this.configuration().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AdministratorUser> getAdminUsers() {
        this.configuration().readLock().lock();
        try {
            JsonNode node = this.getConfiguration().path("users");
            HashSet<AdministratorUser> users = new HashSet<AdministratorUser>(node.size());
            node.fieldNames().forEachRemaining(name -> users.add(new JsonAdministratorUser((String)name, node.path(name).asText(null))));
            HashSet<AdministratorUser> hashSet = users;
            return hashSet;
        }
        finally {
            this.configuration().readLock().unlock();
        }
    }

    @Override
    public void saveAdminUser(AdministratorUser user) {
        this.configuration().writeLock().lock();
        try {
            this.getConfiguration().with("users").put(user.getUsername(), user.getPassword());
            this.configuration().writeNow();
        }
        finally {
            this.configuration().writeLock().unlock();
        }
    }

    @Override
    public void deleteAll() {
        this.configuration().writeLock().lock();
        try {
            this.getConfiguration().remove("users");
            this.configuration().scheduleWrite();
        }
        finally {
            this.configuration().writeLock().unlock();
        }
    }
}

