/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class XmlFactories {
    private static final String XML_VERSION = "1.0";
    private static final String INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private final TransformerFactory transformerFactory;
    private final XMLEventFactory eventFactory;
    private final XMLOutputFactory outputFactory;
    private final XMLInputFactory inputFactory;
    private final Charset DOCUMENT_ENCODING = StandardCharsets.UTF_8;

    public XmlFactories() {
        this.inputFactory = this.createInputFactory();
        this.outputFactory = this.createOutputFactory();
        this.eventFactory = this.createEventFactory();
        this.transformerFactory = this.createTransformerFactory();
    }

    public XMLEventFactory eventFactory() {
        return this.eventFactory;
    }

    public XMLOutputFactory outputFactory() {
        return this.outputFactory;
    }

    public XMLInputFactory inputFactory() {
        return this.inputFactory;
    }

    public Charset documentEncoding() {
        return this.DOCUMENT_ENCODING;
    }

    public String documentVersion() {
        return XML_VERSION;
    }

    public TransformerFactory transformerFactory() {
        return this.transformerFactory;
    }

    private TransformerFactory createTransformerFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        return factory;
    }

    private XMLInputFactory createInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        return factory;
    }

    private XMLOutputFactory createOutputFactory() {
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        factory.setProperty("escapeCharacters", false);
        return factory;
    }

    private XMLEventFactory createEventFactory() {
        XMLEventFactory factory = XMLEventFactory.newFactory();
        return factory;
    }

    public Transformer createIndentingTransformer() throws TransformerException {
        Transformer transformer = this.transformerFactory().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("version", XML_VERSION);
        transformer.setOutputProperty("encoding", "UTF-8");
        try {
            transformer.setOutputProperty(INDENT_AMOUNT, "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return transformer;
    }

    public XMLStreamException unexpectedTag(StartElement element) {
        String message = String.format("unexpected tag: %s", element.getName());
        return new XMLStreamException(message, element.getLocation());
    }

    public XMLStreamException eof() {
        return new XMLStreamException("premature end of file");
    }
}

