/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.response;

import com.google.common.base.Charsets;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.main.api.sax.EXIResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.iceland.coding.encode.AbstractResponseWriter;
import org.n52.iceland.coding.encode.ResponseProxy;
import org.n52.iceland.coding.encode.ResponseWriterKey;
import org.n52.janmayen.Producer;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.exi.EXIObject;
import org.n52.svalbard.encode.EncoderRepository;
import org.n52.svalbard.encode.exception.EncodingException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EXIResponseWriter
extends AbstractResponseWriter<EXIObject<XmlObject>> {
    public static final ResponseWriterKey KEY = new ResponseWriterKey(EXIObject.class);
    private final Producer<EXIFactory> exiFactory;
    private final Producer<XmlOptions> xmlOptions;

    public EXIResponseWriter(EncoderRepository encoderRepository, Producer<EXIFactory> exiFactory, Producer<XmlOptions> xmlOptions) {
        super(encoderRepository);
        this.exiFactory = exiFactory;
        this.xmlOptions = xmlOptions;
    }

    public Set<ResponseWriterKey> getKeys() {
        return Collections.singleton(KEY);
    }

    @Override
    public void write(EXIObject<XmlObject> exiObject, OutputStream out, ResponseProxy responseProxy) throws IOException, EncodingException {
        byte[] bytes = this.getBytes(exiObject);
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            EXIResult result = new EXIResult((EXIFactory)this.exiFactory.get());
            result.setOutputStream(out);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(result.getHandler());
            xmlReader.parse(new InputSource(is));
        }
        catch (EXIException | SAXException e) {
            throw new EncodingException(e);
        }
    }

    private byte[] getBytes(EXIObject<XmlObject> exi) {
        XmlObject doc = (XmlObject)exi.getDoc();
        String text = doc.xmlText((XmlOptions)this.xmlOptions.get());
        return text.getBytes(Charsets.UTF_8);
    }

    @Override
    public MediaType getContentType() {
        return MediaTypes.APPLICATION_EXI;
    }

    @Override
    public void setContentType(MediaType contentType) {
    }

    @Override
    public boolean supportsGZip(EXIObject<XmlObject> t) {
        return false;
    }
}

