/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.request.operator;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.iceland.request.operator.RequestOperator;
import org.n52.iceland.request.operator.RequestOperatorFactory;
import org.n52.iceland.request.operator.RequestOperatorKey;
import org.n52.iceland.util.activation.Activatables;
import org.n52.iceland.util.activation.ActivationListener;
import org.n52.iceland.util.activation.ActivationListeners;
import org.n52.iceland.util.activation.ActivationManager;
import org.n52.iceland.util.activation.ActivationSource;
import org.n52.janmayen.Producer;
import org.n52.janmayen.component.AbstractComponentRepository;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;

public class RequestOperatorRepository
extends AbstractComponentRepository<RequestOperatorKey, RequestOperator, RequestOperatorFactory>
implements ActivationManager<RequestOperatorKey>,
ActivationSource<RequestOperatorKey>,
Constructable {
    private final Map<RequestOperatorKey, Producer<RequestOperator>> requestOperators = Maps.newHashMap();
    private final ActivationListeners<RequestOperatorKey> activation = new ActivationListeners(true);
    @Inject
    private Optional<Collection<RequestOperator>> components = Optional.of(Collections.emptyList());
    @Inject
    private Optional<Collection<RequestOperatorFactory>> componentFactories = Optional.of(Collections.emptyList());

    public void init() {
        Map implementations = this.getUniqueProviders(this.components, this.componentFactories);
        this.requestOperators.clear();
        for (Map.Entry entry : implementations.entrySet()) {
            if (!((RequestOperator)((Producer)entry.getValue()).get()).isSupported()) continue;
            this.requestOperators.put((RequestOperatorKey)entry.getKey(), (Producer<RequestOperator>)((Producer)entry.getValue()));
        }
    }

    public RequestOperator getRequestOperator(RequestOperatorKey key) {
        if (this.isActive(key)) {
            Producer<RequestOperator> producer = this.requestOperators.get(key);
            return producer == null ? null : (RequestOperator)producer.get();
        }
        return null;
    }

    public RequestOperator getRequestOperator(OwsServiceKey sok, String operationName) {
        return this.getRequestOperator(new RequestOperatorKey(sok, operationName));
    }

    public Set<RequestOperator> getRequestOperators() {
        return this.requestOperators.entrySet().stream().filter(e -> this.activation.isActive((RequestOperatorKey)e.getKey())).map(Map.Entry::getValue).map(Producer::get).collect(Collectors.toSet());
    }

    @Override
    public void setActive(RequestOperatorKey rokt, boolean active) {
        this.activation.setActive(rokt, active);
    }

    public Set<RequestOperator> getActiveRequestOperators(OwsServiceKey sok) {
        return this.activeRequestOperatorStream(sok).map(Map.Entry::getValue).map(Producer::get).collect(Collectors.toSet());
    }

    public Set<RequestOperatorKey> getActiveRequestOperatorKeys() {
        return Activatables.activatedKeys(this.requestOperators, this.activation);
    }

    public Set<RequestOperatorKey> getActiveRequestOperatorKeys(OwsServiceKey sok) {
        return this.activeRequestOperatorStream(sok).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Stream<Map.Entry<RequestOperatorKey, Producer<RequestOperator>>> activeRequestOperatorStream(OwsServiceKey sok) {
        return this.requestOperators.entrySet().stream().filter(e -> this.activation.isActive((RequestOperatorKey)e.getKey())).filter(e -> ((RequestOperatorKey)e.getKey()).getServiceOperatorKey().equals((Object)sok));
    }

    @Override
    public boolean isActive(RequestOperatorKey rok) {
        return this.activation.isActive(rok);
    }

    @Override
    public void registerListener(ActivationListener<RequestOperatorKey> listener) {
        this.activation.registerListener(listener);
    }

    @Override
    public void deregisterListener(ActivationListener<RequestOperatorKey> listener) {
        this.activation.deregisterListener(listener);
    }

    @Override
    public void activate(RequestOperatorKey key) {
        this.activation.activate(key);
    }

    @Override
    public void deactivate(RequestOperatorKey key) {
        this.activation.deactivate(key);
    }

    @Override
    public Set<RequestOperatorKey> getKeys() {
        return Collections.unmodifiableSet(this.requestOperators.keySet());
    }
}

