/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public final class MoreFiles {
    private MoreFiles() {
    }

    public static void deleteRecursively(Path path) throws IOException {
        Files.walkFileTree(path, new DeletingFileVisitor());
    }

    private static class DeletingFileVisitor
    extends SimpleFileVisitor<Path> {
        private DeletingFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

