/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.request.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import org.n52.iceland.util.activation.DefaultActive;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;

public class RequestOperatorKey
implements Comparable<RequestOperatorKey>,
DefaultActive {
    private final OwsServiceKey sok;
    private final String operationName;
    private final boolean defaultActive;

    public RequestOperatorKey(OwsServiceKey sok, String operationName) {
        this(sok, operationName, true);
    }

    public RequestOperatorKey(OwsServiceKey sok, String operationName, boolean defaultActive) {
        this.sok = sok;
        this.operationName = operationName;
        this.defaultActive = defaultActive;
    }

    public RequestOperatorKey(String service, String version, String operationName) {
        this(new OwsServiceKey(service, version), operationName, true);
    }

    public RequestOperatorKey(String service, String version, String operationName, boolean defaultActive) {
        this(new OwsServiceKey(service, version), operationName, defaultActive);
    }

    public RequestOperatorKey(OwsServiceKey sok, Enum<?> operationName) {
        this(sok, operationName.name());
    }

    public RequestOperatorKey(OwsServiceKey sok, Enum<?> operationName, boolean defaultActive) {
        this(sok, operationName.name(), defaultActive);
    }

    public RequestOperatorKey(String service, String version, Enum<?> operationName) {
        this(service, version, operationName.name());
    }

    public RequestOperatorKey(String service, String version, Enum<?> operationName, boolean defaultActive) {
        this(service, version, operationName.name(), defaultActive);
    }

    public OwsServiceKey getServiceOperatorKey() {
        return this.sok;
    }

    public String getService() {
        return this.sok == null ? null : this.sok.getService();
    }

    public String getVersion() {
        return this.sok == null ? null : this.sok.getVersion();
    }

    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public boolean isDefaultActive() {
        return this.defaultActive;
    }

    @Override
    public int compareTo(RequestOperatorKey o) {
        Preconditions.checkNotNull((Object)o);
        return ComparisonChain.start().compare((Comparable)this.getServiceOperatorKey(), (Comparable)o.getServiceOperatorKey()).compare((Comparable)((Object)this.getOperationName()), (Comparable)((Object)o.getOperationName())).result();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            RequestOperatorKey o = (RequestOperatorKey)obj;
            return Objects.equal((Object)this.getServiceOperatorKey(), (Object)o.getServiceOperatorKey()) && Objects.equal((Object)this.getOperationName(), (Object)o.getOperationName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getServiceOperatorKey(), this.getOperationName()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceOperatorKey", (Object)this.getServiceOperatorKey()).add("operationName", (Object)this.getOperationName()).add("defaultActive", this.isDefaultActive()).toString();
    }
}

