/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.ogc;

import java.util.Comparator;
import java.util.Objects;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;

public abstract class AbstractComparableServiceVersionDomainKey<T extends AbstractComparableServiceVersionDomainKey<T>>
implements Comparable<T> {
    private OwsServiceKey serviceKey;
    private String domain;

    public AbstractComparableServiceVersionDomainKey(OwsServiceKey sok, String domain) {
        this.setServiceOperatorKey(sok);
        this.setDomain(domain);
    }

    public AbstractComparableServiceVersionDomainKey(String service, String version, String domain) {
        this(new OwsServiceKey(service, version), domain);
    }

    private void setServiceOperatorKey(OwsServiceKey key) {
        this.serviceKey = key;
    }

    public OwsServiceKey getServiceOperatorKey() {
        return this.serviceKey;
    }

    public String getService() {
        return this.serviceKey == null ? null : this.serviceKey.getService();
    }

    public String getVersion() {
        return this.serviceKey == null ? null : this.serviceKey.getVersion();
    }

    public String getDomain() {
        return this.domain;
    }

    private void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public int compareTo(T other) {
        return Comparator.comparing(AbstractComparableServiceVersionDomainKey::getServiceOperatorKey).thenComparing(AbstractComparableServiceVersionDomainKey::getDomain).compare(this, (AbstractComparableServiceVersionDomainKey)other);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            AbstractComparableServiceVersionDomainKey o = (AbstractComparableServiceVersionDomainKey)obj;
            return Objects.equals(this.getServiceOperatorKey(), o.getServiceOperatorKey()) && Objects.equals(this.getDomain(), o.getDomain());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getServiceOperatorKey(), this.getDomain());
    }

    public String toString() {
        return String.format("%s[serviceOperatorKeyType=%s, domain=%s]", this.getClass().getSimpleName(), this.getServiceOperatorKey(), this.getDomain());
    }
}

