/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.convert;

import java.util.Comparator;
import java.util.Objects;

public class ConverterKey
implements Comparable<ConverterKey> {
    private static final Comparator<ConverterKey> COMPARATOR = Comparator.nullsFirst(Comparator.comparing(ConverterKey::getFromNamespace, Comparator.nullsFirst(String::compareTo)).thenComparing(Comparator.comparing(ConverterKey::getToNamespace, Comparator.nullsFirst(String::compareTo))));
    private final String fromNamespace;
    private final String toNamespace;

    public ConverterKey(String fromNamespace, String toNamespace) {
        this.fromNamespace = fromNamespace;
        this.toNamespace = toNamespace;
    }

    public String getFromNamespace() {
        return this.fromNamespace;
    }

    public String getToNamespace() {
        return this.toNamespace;
    }

    @Override
    public int compareTo(ConverterKey o) {
        return ConverterKey.compare(this, o);
    }

    public boolean equals(Object paramObject) {
        if (paramObject instanceof ConverterKey) {
            ConverterKey toCheck = (ConverterKey)paramObject;
            return Objects.equals(this.getFromNamespace(), toCheck.getFromNamespace()) && Objects.equals(this.getToNamespace(), toCheck.getToNamespace());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getFromNamespace(), this.getToNamespace());
    }

    public String toString() {
        return String.format("%s[from=%s, to=%s]", this.getClass().getSimpleName(), this.fromNamespace, this.toNamespace);
    }

    public static int compare(ConverterKey o1, ConverterKey o2) {
        return COMPARATOR.compare(o1, o2);
    }
}

