/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.i18n;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.janmayen.i18n.LocalizedString;
import org.n52.janmayen.i18n.MultilingualString;

public class I18NSerializer {
    private static final String TUPLE_SEPERATOR = "&";
    private static final String TOKEN_SEPERATOR = "=";
    private static final String UTF8 = "UTF-8";

    public String encode(MultilingualString string) {
        Iterator it = string.iterator();
        StringBuilder builder = new StringBuilder();
        if (it.hasNext()) {
            this.encode(builder, (LocalizedString)it.next());
            while (it.hasNext()) {
                builder.append(TUPLE_SEPERATOR);
                this.encode(builder, (LocalizedString)it.next());
            }
        }
        return builder.toString();
    }

    private StringBuilder encode(StringBuilder builder, LocalizedString loc) {
        return builder.append(LocaleHelper.encode((Locale)loc.getLang())).append(TOKEN_SEPERATOR).append(I18NSerializer.encodeText(loc.getText()));
    }

    public MultilingualString decode(String string) {
        MultilingualString mls = new MultilingualString();
        for (String s : string.split(TUPLE_SEPERATOR)) {
            String[] kvp = s.split(TOKEN_SEPERATOR);
            mls.addLocalization(LocaleHelper.decode((String)kvp[0]), I18NSerializer.decodeText(kvp[1]));
        }
        return mls;
    }

    private static String decodeText(String text) {
        try {
            return URLDecoder.decode(text, UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String encodeText(String text) {
        try {
            return URLEncoder.encode(text, UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

