/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.convert;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.n52.iceland.convert.RequestResponseModifier;
import org.n52.iceland.convert.RequestResponseModifierFactory;
import org.n52.iceland.convert.RequestResponseModifierKey;
import org.n52.janmayen.Producer;
import org.n52.janmayen.component.AbstractComponentRepository;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;

public class RequestResponseModifierRepository
extends AbstractComponentRepository<RequestResponseModifierKey, RequestResponseModifier, RequestResponseModifierFactory>
implements Constructable {
    private final Map<RequestResponseModifierKey, Set<Producer<RequestResponseModifier>>> requestResponseModifier = new HashMap<RequestResponseModifierKey, Set<Producer<RequestResponseModifier>>>();
    @Inject
    private Optional<Collection<RequestResponseModifier>> components = Optional.of(Collections.emptyList());
    @Inject
    private Optional<Collection<RequestResponseModifierFactory>> componentFactories = Optional.of(Collections.emptyList());

    public void init() {
        Map implementations = this.getProviders(this.components, this.componentFactories);
        this.requestResponseModifier.clear();
        this.requestResponseModifier.putAll(implementations);
    }

    public List<RequestResponseModifier> getRequestResponseModifier(OwsServiceRequest request) {
        RequestResponseModifierKey key = new RequestResponseModifierKey(request.getService(), request.getVersion(), request);
        return this.getRequestResponseModifier(key);
    }

    public List<RequestResponseModifier> getRequestResponseModifier(OwsServiceRequest request, OwsServiceResponse response) {
        RequestResponseModifierKey key = new RequestResponseModifierKey(response.getService(), response.getVersion(), request, response);
        return this.getRequestResponseModifier(key);
    }

    public List<RequestResponseModifier> getRequestResponseModifier(RequestResponseModifierKey key) {
        Set<Producer<RequestResponseModifier>> producers = this.requestResponseModifier.get(key);
        if (producers == null) {
            return null;
        }
        return producers.stream().map(Producer::get).collect(Collectors.toList());
    }

    public boolean hasRequestResponseModifier(OwsServiceRequest request) {
        return this.hasRequestResponseModifier(new RequestResponseModifierKey(request.getService(), request.getVersion(), request));
    }

    public boolean hasRequestResponseModifier(OwsServiceRequest request, OwsServiceResponse response) {
        return this.hasRequestResponseModifier(new RequestResponseModifierKey(request.getService(), request.getVersion(), request, response)) && this.hasRequestResponseModifier(new RequestResponseModifierKey(response.getService(), response.getVersion(), request, response));
    }

    public boolean hasRequestResponseModifier(RequestResponseModifierKey key) {
        return this.requestResponseModifier.containsKey(key);
    }
}

