/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util.activation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.n52.iceland.util.activation.Activatable;
import org.n52.iceland.util.activation.ActivationProvider;

public final class Activatables {
    private Activatables() {
    }

    public static <K, V> Map<K, V> filter(Map<K, Activatable<V>> map) {
        return Optional.ofNullable(map).orElseGet(HashMap::new).entrySet().stream().filter(e -> e.getValue() != null).filter(e -> ((Activatable)e.getValue()).isActive()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Activatable)e.getValue()).get()));
    }

    public static <E> Set<E> filter(Set<Activatable<E>> set) {
        return Optional.ofNullable(set).orElseGet(HashSet::new).stream().filter(Activatable::isActive).map(Activatable::get).collect(Collectors.toSet());
    }

    public static <E> Set<E> unfiltered(Set<Activatable<E>> set) {
        return Optional.ofNullable(set).orElseGet(HashSet::new).stream().map(Activatable::getInternal).collect(Collectors.toSet());
    }

    public static <K, V> Map<K, V> unfiltered(Map<K, Activatable<V>> map) {
        return Optional.ofNullable(map).orElseGet(HashMap::new).entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Activatable)e.getValue()).getInternal()));
    }

    public static <E> Set<Activatable<E>> from(Set<E> set) {
        return set.stream().map(Activatables::from).collect(Collectors.toSet());
    }

    public static <T> Activatable<T> from(T t) {
        return Activatables.from(t, true);
    }

    public static <T> Activatable<T> from(T t, boolean active) {
        return new Activatable<T>(t, active);
    }

    public static <K, T> Set<K> activatedKeys(Map<K, T> map, ActivationProvider<? super K> provider) {
        return Sets.filter(map.keySet(), provider::isActive);
    }

    public static <K, T> Set<T> activatedSet(Map<K, T> map, ActivationProvider<? super K> provider) {
        return new HashSet<T>(Activatables.activatedMap(map, provider).values());
    }

    public static <K, T> Map<K, T> activatedMap(Map<K, T> map, ActivationProvider<? super K> provider) {
        return Maps.filterKeys(map, provider::isActive);
    }

    public static <K, T> Set<K> deactivatedKeys(Map<K, T> map, ActivationProvider<? super K> provider) {
        return Sets.filter(map.keySet(), (Predicate)Predicates.not(provider::isActive));
    }

    public static <K, T> Set<T> deactivatedSet(Map<K, T> map, ActivationProvider<? super K> provider) {
        return new HashSet<T>(Activatables.deactivatedMap(map, provider).values());
    }

    public static <K, T> Map<K, T> deactivatedMap(Map<K, T> map, ActivationProvider<? super K> provider) {
        return Maps.filterKeys(map, (Predicate)Predicates.not(provider::isActive));
    }
}

