/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.service.operator;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.n52.iceland.request.operator.RequestOperator;
import org.n52.iceland.request.operator.RequestOperatorRepository;
import org.n52.iceland.service.operator.ServiceOperator;
import org.n52.shetland.ogc.ows.exception.OperationNotSupportedException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;

public class GenericServiceOperator
implements ServiceOperator {
    private RequestOperatorRepository requestOperatorRepository;
    private final OwsServiceKey key;
    private final String service;
    private final String version;

    public GenericServiceOperator(String service, String version) {
        this.service = Objects.requireNonNull(service);
        this.version = Objects.requireNonNull(version);
        this.key = new OwsServiceKey(service, version);
    }

    public OwsServiceKey getKey() {
        return this.key;
    }

    @Inject
    public void setRequestOperatorRepository(RequestOperatorRepository repo) {
        this.requestOperatorRepository = repo;
    }

    public Set<OwsServiceKey> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public OwsServiceResponse receiveRequest(OwsServiceRequest request) throws OwsExceptionReport {
        String operationName = request.getOperationName();
        RequestOperator operator = this.requestOperatorRepository.getRequestOperator(this.key, operationName);
        if (operator == null) {
            throw new OperationNotSupportedException(operationName);
        }
        OwsServiceResponse response = operator.receiveRequest(request);
        if (response == null) {
            throw new OperationNotSupportedException(operationName);
        }
        return response;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GenericServiceOperator)) {
            return false;
        }
        GenericServiceOperator that = (GenericServiceOperator)obj;
        return Objects.equals(this.getKey(), that.getKey());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("service", (Object)this.service).add("version", (Object)this.version).toString();
    }
}

