/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.iceland.coding.encode.AbstractResponseWriter;
import org.n52.iceland.coding.encode.ResponseProxy;
import org.n52.iceland.coding.encode.ResponseWriterKey;
import org.n52.janmayen.Producer;
import org.n52.shetland.w3c.soap.SoapChain;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncoderRepository;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.n52.svalbard.util.CodingHelper;

public class SoapChainResponseWriter
extends AbstractResponseWriter<SoapChain> {
    public static final ResponseWriterKey KEY = new ResponseWriterKey(SoapChain.class);
    private final Producer<XmlOptions> xmlOptions;
    private final boolean forceStreamingEncoding;

    public SoapChainResponseWriter(EncoderRepository encoderRepository, Producer<XmlOptions> xmlOptions, boolean forceStreamingEncoding) {
        super(encoderRepository);
        this.xmlOptions = xmlOptions;
        this.forceStreamingEncoding = forceStreamingEncoding;
    }

    public Set<ResponseWriterKey> getKeys() {
        return Collections.singleton(KEY);
    }

    @Override
    public void write(SoapChain chain, OutputStream out, ResponseProxy responseProxy) throws IOException {
        try {
            this.write(chain, out);
        }
        catch (EncodingException ex) {
            throw new IOException(ex);
        }
    }

    private void write(SoapChain chain, OutputStream out) throws EncodingException, IOException {
        String namespace = chain.getSoapResponse().getSoapNamespace();
        EncoderKey key = CodingHelper.getEncoderKey((String)namespace, (Object)chain.getSoapResponse());
        Encoder encoder = this.getEncoder(key);
        if (encoder == null) {
            throw new NoEncoderForKeyException((Object)key);
        }
        this.write(encoder, chain, out);
    }

    private void write(Encoder<?, SoapResponse> encoder, SoapChain chain, OutputStream out) throws IOException, EncodingException {
        if (this.forceStreamingEncoding && encoder instanceof StreamingEncoder) {
            ((StreamingEncoder)encoder).encode((Object)chain.getSoapResponse(), out);
        } else {
            try {
                Object object = encoder.encode((Object)chain.getSoapResponse());
                if (object instanceof SOAPMessage) {
                    ((SOAPMessage)object).writeTo(out);
                } else if (object instanceof XmlObject) {
                    ((XmlObject)object).save(out, (XmlOptions)this.xmlOptions.get());
                }
            }
            catch (SOAPException ex) {
                throw new IOException(ex);
            }
        }
    }

    @Override
    public boolean supportsGZip(SoapChain t) {
        return false;
    }
}

