/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.request.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.n52.iceland.exception.ows.concrete.InvalidServiceParameterException;
import org.n52.iceland.ogc.ows.OwsServiceMetadataRepository;
import org.n52.iceland.request.handler.AbstractOperationHandler;
import org.n52.iceland.request.handler.GenericOperationHandler;
import org.n52.iceland.request.handler.OperationHandlerKey;
import org.n52.iceland.request.operator.RequestOperatorKey;
import org.n52.iceland.request.operator.RequestOperatorRepository;
import org.n52.iceland.service.operator.ServiceOperatorRepository;
import org.n52.janmayen.Comparables;
import org.n52.janmayen.http.MediaTypes;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.shetland.ogc.ows.OWSConstants;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.OwsCapabilitiesExtension;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.ogc.ows.OwsNoValues;
import org.n52.shetland.ogc.ows.OwsOperationMetadataExtension;
import org.n52.shetland.ogc.ows.OwsOperationsMetadata;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsServiceIdentification;
import org.n52.shetland.ogc.ows.OwsServiceProvider;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.ows.OwsValueRestriction;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.exception.VersionNegotiationFailedException;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;

public abstract class AbstractGetCapabilitiesHandler<T>
extends AbstractOperationHandler
implements GenericOperationHandler<GetCapabilitiesRequest, GetCapabilitiesResponse> {
    private final OperationHandlerKey key;
    private OwsServiceMetadataRepository serviceMetadataRepository;
    private RequestOperatorRepository requestOperatorRepository;
    private ServiceOperatorRepository serviceOperatorRepository;

    public AbstractGetCapabilitiesHandler(String service) {
        this.key = new OperationHandlerKey(service, (Enum<?>)OWSConstants.Operations.GetCapabilities);
    }

    @Inject
    public void setServiceMetadataRepository(OwsServiceMetadataRepository serviceMetadataRepository) {
        this.serviceMetadataRepository = serviceMetadataRepository;
    }

    @Inject
    public void setRequestOperatorRepository(RequestOperatorRepository requestOperatorRepository) {
        this.requestOperatorRepository = requestOperatorRepository;
    }

    @Inject
    public void setServiceOperatorRepository(ServiceOperatorRepository serviceOperatorRepository) {
        this.serviceOperatorRepository = serviceOperatorRepository;
    }

    @Override
    public String getOperationName() {
        return OWSConstants.Operations.GetCapabilities.toString();
    }

    public Set<OperationHandlerKey> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public GetCapabilitiesResponse handle(GetCapabilitiesRequest request) throws OwsExceptionReport {
        String service = request.getService();
        String version = this.negotiateVersion(request);
        GetCapabilitiesResponse response = this.createResponse(service, version);
        response.setCapabilities(this.createCapabilities(request, service, version));
        return response;
    }

    protected GetCapabilitiesResponse createResponse(String service, String version) {
        return new GetCapabilitiesResponse(service, version);
    }

    public List<OwsServiceKey> getServiceOperatorKeys(GetCapabilitiesRequest request) {
        String service = request.getService();
        if (request.isSetAcceptVersions()) {
            return request.getAcceptVersions().stream().map(version -> new OwsServiceKey(service, version)).collect(Collectors.toList());
        }
        return this.serviceOperatorRepository.getSupportedVersions(service).stream().max(Comparables.version()).map(version -> new OwsServiceKey(service, version)).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    private String negotiateVersion(GetCapabilitiesRequest request) throws OwsExceptionReport {
        if (request.isSetVersion()) {
            return request.getVersion();
        }
        String service = request.getService();
        String version = request.isSetAcceptVersions() ? request.getAcceptVersions().stream().filter(v -> this.serviceOperatorRepository.isVersionSupported(service, (String)v)).findFirst().orElseThrow(this::versionNegotiationFailed) : (String)this.serviceOperatorRepository.getSupportedVersions(service).stream().max(Comparables.version()).orElseThrow(() -> new InvalidServiceParameterException(service));
        request.setVersion(version);
        return version;
    }

    private OwsExceptionReport versionNegotiationFailed() {
        return new VersionNegotiationFailedException().withMessage("The requested '%s' values are not supported by this service!", new Object[]{OWSConstants.GetCapabilitiesParams.AcceptVersions});
    }

    @Override
    protected Set<OwsDomain> getOperationParameters(String service, String version) {
        OwsDomain acceptFormats = this.getAcceptFormatsDomain();
        OwsDomain acceptVersions = this.getAcceptVersionsDomain(service);
        OwsDomain sections = this.getSectionsDomain();
        OwsDomain updateSequence = this.getUpdateSequenceDomain();
        OwsDomain acceptLanguages = this.getAcceptLanguagesDomain();
        return new HashSet<OwsDomain>(Arrays.asList(acceptFormats, acceptVersions, acceptLanguages, sections, updateSequence));
    }

    private OwsOperationsMetadata getOperations(String service, String version) throws OwsExceptionReport {
        Collection<OwsDomain> parameters = this.getCommonParameters(service);
        Collection constraints = null;
        LinkedList operations = new LinkedList();
        OwsOperationMetadataExtension extension = this.getOperationsMetadataExtension(service, version);
        for (RequestOperatorKey operatorKey : this.requestOperatorRepository.getActiveRequestOperatorKeys(new OwsServiceKey(service, version))) {
            Optional.ofNullable(this.requestOperatorRepository.getRequestOperator(operatorKey).getOperationMetadata(service, version)).ifPresent(operations::add);
        }
        return new OwsOperationsMetadata(operations, parameters, constraints, extension);
    }

    protected OwsOperationMetadataExtension getOperationsMetadataExtension(String service, String version) {
        return null;
    }

    private Collection<OwsDomain> getCommonParameters(String service) {
        OwsDomain serviceParameter = new OwsDomain((Enum)OWSConstants.RequestParams.service, (OwsPossibleValues)new OwsAllowedValues(new OwsValueRestriction[]{new OwsValue(service)}));
        OwsDomain versionParameter = new OwsDomain((Enum)OWSConstants.RequestParams.version, (OwsPossibleValues)this.getSupportedVersions(service));
        return Arrays.asList(serviceParameter, versionParameter);
    }

    private OwsAllowedValues getSupportedVersions(String service) {
        Set<String> supportedVersions = this.serviceOperatorRepository.getSupportedVersions(service);
        return new OwsAllowedValues(supportedVersions.stream().map(OwsValue::new));
    }

    private OwsServiceProvider getServiceProvider(String service, Locale locale) {
        return this.serviceMetadataRepository.getServiceProviderFactory(service).get(locale);
    }

    private OwsServiceIdentification getServiceIdentification(String service, Locale locale) {
        return this.serviceMetadataRepository.getServiceIdentificationFactory(service).get(locale);
    }

    private Set<OWSConstants.CapabilitiesSection> getRequestedSections(GetCapabilitiesRequest request) {
        Set<OWSConstants.CapabilitiesSection> sections = request.getSections().stream().map(OWSConstants.CapabilitiesSection::from).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (sections.contains(OWSConstants.CapabilitiesSection.All) || sections.isEmpty()) {
            sections.addAll(Arrays.asList(OWSConstants.CapabilitiesSection.values()));
        }
        return sections;
    }

    private OwsDomain getAcceptFormatsDomain() {
        OwsValue defaultValue = new OwsValue(MediaTypes.APPLICATION_XML.toString());
        OwsAllowedValues possibleValues = new OwsAllowedValues(new OwsValueRestriction[]{defaultValue});
        return new OwsDomain((Enum)OWSConstants.GetCapabilitiesParams.AcceptFormats, (OwsPossibleValues)possibleValues, defaultValue);
    }

    private OwsDomain getAcceptVersionsDomain(String service) {
        Set<String> supportedVersions = this.serviceOperatorRepository.getSupportedVersions(service);
        OwsValue defaultValue = new OwsValue((String)Comparables.version().max(supportedVersions));
        OwsAllowedValues possibleValues = new OwsAllowedValues(supportedVersions.stream().map(OwsValue::new));
        return new OwsDomain((Enum)OWSConstants.GetCapabilitiesParams.AcceptVersions, (OwsPossibleValues)possibleValues, defaultValue);
    }

    private OwsDomain getSectionsDomain() {
        OwsAllowedValues possibleValues = new OwsAllowedValues(Arrays.stream(OWSConstants.CapabilitiesSection.values()).map(Object::toString).map(OwsValue::new));
        OwsValue defaultValue = new OwsValue(OWSConstants.CapabilitiesSection.All.toString());
        return new OwsDomain((Enum)OWSConstants.GetCapabilitiesParams.Sections, (OwsPossibleValues)possibleValues, defaultValue);
    }

    private OwsDomain getUpdateSequenceDomain() {
        OwsNoValues possibleValues = OwsNoValues.instance();
        return new OwsDomain((Enum)OWSConstants.GetCapabilitiesParams.updateSequence, (OwsPossibleValues)possibleValues);
    }

    private OwsDomain getAcceptLanguagesDomain() {
        Set<Locale> availableLocales = this.serviceMetadataRepository.getAvailableLocales();
        OwsAllowedValues possibleValues = new OwsAllowedValues(availableLocales.stream().map(LocaleHelper::encode).map(OwsValue::new));
        return new OwsDomain((Enum)OWSConstants.GetCapabilitiesParams.AcceptLanguages, (OwsPossibleValues)possibleValues);
    }

    private Set<String> getLanguages() {
        Set<Locale> availableLocales = this.serviceMetadataRepository.getAvailableLocales();
        return availableLocales.stream().map(LocaleHelper::encode).collect(Collectors.toSet());
    }

    private OwsCapabilities createCapabilities(GetCapabilitiesRequest request, String service, String version) throws OwsExceptionReport {
        Set<OWSConstants.CapabilitiesSection> sections = this.getRequestedSections(request);
        Locale requestedLocale = this.getRequestedLocale((OwsServiceRequest)request);
        String updateSequence = null;
        OwsServiceIdentification serviceIdentification = null;
        if (sections.contains(OWSConstants.CapabilitiesSection.ServiceIdentification)) {
            serviceIdentification = this.getServiceIdentification(service, requestedLocale);
        }
        OwsServiceProvider serviceProvider = null;
        if (sections.contains(OWSConstants.CapabilitiesSection.ServiceProvider)) {
            serviceProvider = this.getServiceProvider(service, requestedLocale);
        }
        OwsOperationsMetadata operationsMetadata = null;
        if (sections.contains(OWSConstants.CapabilitiesSection.OperationsMetadata)) {
            operationsMetadata = this.getOperations(service, version);
        }
        Set<String> languages = null;
        if (sections.contains(OWSConstants.CapabilitiesSection.Languages)) {
            languages = this.getLanguages();
        }
        T contents = null;
        if (sections.contains(OWSConstants.CapabilitiesSection.Contents)) {
            contents = this.createContents(service, version);
        }
        Collection<OwsCapabilitiesExtension> extensions = this.getExtensions(request, service, version);
        OwsCapabilities capabilities = new OwsCapabilities(service, version, updateSequence, serviceIdentification, serviceProvider, operationsMetadata, languages, extensions);
        return this.createCapabilities(capabilities, contents);
    }

    protected abstract OwsCapabilities createCapabilities(OwsCapabilities var1, T var2);

    protected Collection<OwsCapabilitiesExtension> getExtensions(GetCapabilitiesRequest request, String service, String version) {
        return Collections.emptyList();
    }

    protected abstract T createContents(String var1, String var2);
}

