/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.i18n.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;
import org.n52.janmayen.i18n.MultilingualString;

public abstract class AbstractI18NMetadata {
    private final String identifier;
    private final MultilingualString name;
    private final MultilingualString description;

    public AbstractI18NMetadata(String id, MultilingualString name, MultilingualString description) {
        this.identifier = id;
        this.name = AbstractI18NMetadata.newIfNull(name);
        this.description = AbstractI18NMetadata.newIfNull(description);
    }

    public AbstractI18NMetadata(String id) {
        this(id, null, null);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public MultilingualString getName() {
        return this.name;
    }

    public MultilingualString getDescription() {
        return this.description;
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("identifier", (Object)this.getIdentifier()).add("name", (Object)this.getName()).add("description", (Object)this.getDescription());
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getIdentifier(), this.getName(), this.getDescription()});
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractI18NMetadata) {
            AbstractI18NMetadata that = (AbstractI18NMetadata)o;
            return Objects.equal((Object)this.getIdentifier(), (Object)that.getIdentifier()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getDescription(), (Object)that.getDescription());
        }
        return false;
    }

    public Set<Locale> getLocales() {
        return Sets.union((Set)this.getName().getLocales(), (Set)this.getDescription().getLocales());
    }

    protected static MultilingualString newIfNull(MultilingualString string) {
        return string == null ? new MultilingualString() : string;
    }
}

