/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.coding.encode;

import org.n52.iceland.coding.encode.ResponseWriter;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.service.ResponseFormat;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncoderRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponseWriter<T>
implements ResponseWriter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResponseWriter.class);
    private MediaType contentType;
    private final EncoderRepository encoderRepository;

    public AbstractResponseWriter(EncoderRepository encoderRepository) {
        this.encoderRepository = encoderRepository;
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(MediaType contentType) {
        this.contentType = contentType;
    }

    protected <D, S> Encoder<D, S> getEncoder(EncoderKey key) {
        return this.encoderRepository.getEncoder(key, new EncoderKey[0]);
    }

    @Override
    public MediaType getEncodedContentType(ResponseFormat responseFormat) {
        if (responseFormat.isSetResponseFormat()) {
            MediaType contentTypeFromResponseFormat = null;
            try {
                contentTypeFromResponseFormat = MediaType.parse((String)responseFormat.getResponseFormat());
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Requested responseFormat {} is not a MediaType", (Object)responseFormat.getResponseFormat());
            }
            if (contentTypeFromResponseFormat != null) {
                if (MediaTypes.COMPATIBLE_TYPES.containsEntry((Object)contentTypeFromResponseFormat.withoutParameters(), (Object)this.getContentType())) {
                    return this.getContentType();
                }
                return contentTypeFromResponseFormat;
            }
        }
        return this.getContentType();
    }

    protected EncoderRepository getEncoderRepository() {
        return this.encoderRepository;
    }
}

