/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.binding.SimpleBinding;
import org.n52.iceland.coding.decode.OwsDecodingException;
import org.n52.iceland.exception.HTTPException;
import org.n52.janmayen.Json;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.OperationDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.NoDecoderForKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONBinding
extends SimpleBinding {
    private static final Logger LOG = LoggerFactory.getLogger(JSONBinding.class);
    private static final String SERVICE = "service";
    private static final String VERSION = "version";
    private static final String REQUEST = "request";
    private static final Set<BindingKey> KEYS = Collections.singleton(new MediaTypeBindingKey(MediaTypes.APPLICATION_JSON));

    public Set<BindingKey> getKeys() {
        return Collections.unmodifiableSet(KEYS);
    }

    @Override
    protected boolean isUseHttpResponseCodes() {
        return true;
    }

    @Override
    protected MediaType getDefaultContentType() {
        return MediaTypes.APPLICATION_JSON;
    }

    @Override
    public boolean checkOperationHttpPostSupported(OwsOperationKey k) throws HTTPException {
        return this.getDecoder((DecoderKey)new OperationDecoderKey(k, MediaTypes.APPLICATION_JSON)) != null;
    }

    @Override
    public void doPostOperation(HttpServletRequest req, HttpServletResponse res) throws HTTPException, IOException {
        OwsServiceRequest request = null;
        try {
            request = this.parseRequest(req);
            this.checkServiceOperatorKeyTypes(request);
            OwsServiceResponse response = this.getServiceOperator(request).receiveRequest(request);
            this.writeResponse(req, res, response);
        }
        catch (OwsExceptionReport oer) {
            oer.setVersion(request != null ? request.getVersion() : null);
            LOG.warn("Unexpected error", (Throwable)oer);
            this.writeOwsExceptionReport(req, res, oer);
        }
    }

    private OwsServiceRequest parseRequest(HttpServletRequest request) throws OwsExceptionReport {
        try {
            OwsServiceRequest sosRequest;
            OperationDecoderKey key;
            Decoder decoder;
            JsonNode json = Json.loadReader((Reader)request.getReader());
            if (LOG.isDebugEnabled()) {
                LOG.debug("JSON-REQUEST: {}", (Object)Json.print((JsonNode)json));
            }
            if ((decoder = this.getDecoder((DecoderKey)(key = new OperationDecoderKey(json.path(SERVICE).textValue(), json.path(VERSION).textValue(), json.path(REQUEST).textValue(), MediaTypes.APPLICATION_JSON)))) == null) {
                NoDecoderForKeyException cause = new NoDecoderForKeyException((DecoderKey)key);
                throw new NoApplicableCodeException().withMessage(cause.getMessage(), new Object[0]).causedBy((Throwable)cause);
            }
            try {
                sosRequest = (OwsServiceRequest)decoder.decode((Object)json);
            }
            catch (OwsDecodingException ex) {
                throw ex.getCause();
            }
            catch (DecodingException ex) {
                throw new NoApplicableCodeException().withMessage(ex.getMessage(), new Object[0]).causedBy((Throwable)ex);
            }
            sosRequest.setRequestContext(this.getRequestContext(request));
            return sosRequest;
        }
        catch (IOException ioe) {
            throw new NoApplicableCodeException().causedBy((Throwable)ioe).withMessage("Error while reading request! Message: %s", new Object[]{ioe.getMessage()});
        }
    }
}

