/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.n52.iceland.util.NonNegativeBigInteger;
import org.n52.iceland.util.PositiveBigInteger;

public class ValidatableBigIntegers {
    @Test
    public void validPositive() {
        PositiveBigInteger pbi = new PositiveBigInteger("52");
        MatcherAssert.assertThat((Object)pbi.intValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)52)));
    }

    @Test
    public void validNonNegative() {
        NonNegativeBigInteger nnbi = new NonNegativeBigInteger("52");
        MatcherAssert.assertThat((Object)nnbi.intValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)52)));
        nnbi = new NonNegativeBigInteger("0");
        MatcherAssert.assertThat((Object)nnbi.intValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void validNonNegativeZero() {
        NonNegativeBigInteger nnbi = new NonNegativeBigInteger("0");
        MatcherAssert.assertThat((Object)nnbi.intValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void invalidPositive() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PositiveBigInteger pbi = new PositiveBigInteger("-1");
        });
    }

    @Test
    public void invalidPositiveZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PositiveBigInteger pbi = new PositiveBigInteger("0");
        });
    }

    @Test
    public void invalidNonNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            NonNegativeBigInteger nnbi = new NonNegativeBigInteger("-1");
        });
    }
}

