/*
 * Copyright 2015-2020 52°North Initiative for Geospatial Open Source
 * Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.iceland.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

import org.n52.iceland.coding.encode.AbstractResponseWriter;
import org.n52.iceland.coding.encode.ResponseProxy;
import org.n52.iceland.coding.encode.ResponseWriterKey;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.svalbard.encode.EncoderRepository;
import org.n52.svalbard.encode.exception.EncodingException;

/**
 * Writer for {@link SOAPMessage} objects
 *
 * @author <a href="mailto:c.autermann@52north.org">Christian Autermann</a>
 * @since 2.0.0
 *
 * @deprecated javax.xml.soap.* is no longer supported from 8.0 because it was removed from Java
 */
@Deprecated
public class SoapResponseWriter extends AbstractResponseWriter<SOAPMessage> {
    public static final ResponseWriterKey KEY = new ResponseWriterKey(SOAPMessage.class);

    public SoapResponseWriter(EncoderRepository encoderRepository) {
        super(encoderRepository);
    }

    @Override
    public Set<ResponseWriterKey> getKeys() {
        return Collections.singleton(KEY);
    }

    @Override
    public void write(SOAPMessage t, OutputStream out, ResponseProxy responseProxy)
            throws IOException, EncodingException {
        try {
            t.writeTo(out);
        } catch (SOAPException soapex) {
            throw new EncodingException(soapex);
        }
    }

    @Override
    public MediaType getContentType() {
        return MediaTypes.APPLICATION_SOAP_XML;
    }

    @Override
    public void setContentType(MediaType contentType) {
    }

    @Override
    public boolean supportsGZip(SOAPMessage t) {
        return false;
    }
}
