/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.config.spring;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ProviderAwareListableBeanFactory
extends DefaultListableBeanFactory
implements Serializable {
    private static final long serialVersionUID = -6826027137321052707L;

    public ProviderAwareListableBeanFactory() {
    }

    public ProviderAwareListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    protected Map<String, Object> findAutowireCandidates(String beanName, Class<?> requiredType, DependencyDescriptor descriptor) {
        if (!requiredType.equals(Provider.class)) {
            return super.findAutowireCandidates(beanName, requiredType, descriptor);
        }
        DependencyDescriptor providedDescriptor = new DependencyDescriptor(descriptor);
        providedDescriptor.increaseNestingLevel();
        Class type = providedDescriptor.getDependencyType();
        Set<String> candidates = this.findAutowireCandidates(beanName, type, providedDescriptor).keySet();
        return candidates.stream().collect(Collectors.toMap(Function.identity(), name -> new DependencyProvider(this, descriptor, (String)name)));
    }

    private static class DependencyProvider
    implements ObjectFactory<Object>,
    Provider<Object>,
    Serializable {
        private static final long serialVersionUID = 2498323681896163119L;
        private final DependencyDescriptor descriptor;
        private final boolean optional;
        private final String beanName;
        private final ProviderAwareListableBeanFactory beanFactory;

        DependencyProvider(ProviderAwareListableBeanFactory beanFactory, DependencyDescriptor descriptor, String beanName) {
            this.beanFactory = beanFactory;
            DependencyDescriptor d = new DependencyDescriptor(descriptor);
            d.increaseNestingLevel();
            this.optional = d.getDependencyType().equals(Optional.class);
            this.descriptor = this.optional ? new OptionalDependencyDescriptor(d) : d;
            this.beanName = beanName;
        }

        public Object getObject() throws BeansException {
            Object resolved = this.beanFactory.getBean(this.beanName);
            return this.optional ? Optional.ofNullable(resolved) : Objects.requireNonNull(resolved);
        }

        public Object get() throws BeansException {
            return this.getObject();
        }
    }

    private static class OptionalDependencyDescriptor
    extends DependencyDescriptor {
        private static final long serialVersionUID = -6623409266686702545L;

        OptionalDependencyDescriptor(DependencyDescriptor original) {
            super(original);
            super.increaseNestingLevel();
        }

        public boolean isRequired() {
            return false;
        }
    }
}

