/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding.kvp;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.n52.janmayen.exception.CompositeException;
import org.n52.janmayen.function.ThrowingBiConsumer;
import org.n52.janmayen.function.ThrowingTriConsumer;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.OWSConstants;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.util.StringHelper;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.OperationDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;

public abstract class AbstractKvpDecoder<R extends OwsServiceRequest>
implements Decoder<R, Map<String, String>> {
    private final Set<DecoderKey> keys;
    private final Supplier<? extends R> supplier;

    public AbstractKvpDecoder(Supplier<? extends R> supplier, String service, String version, String operation) {
        this(supplier, new DecoderKey[]{new OperationDecoderKey(service, version, operation, MediaTypes.APPLICATION_KVP)});
    }

    public AbstractKvpDecoder(Supplier<? extends R> supplier, String service, String version, Enum<?> operation) {
        this(supplier, service, version, operation.name());
    }

    public AbstractKvpDecoder(Supplier<? extends R> supplier, DecoderKey ... keys) {
        this(supplier, Arrays.asList(keys));
    }

    public AbstractKvpDecoder(Supplier<? extends R> supplier, Collection<? extends DecoderKey> keys) {
        this.supplier = Objects.requireNonNull(supplier);
        this.keys = new HashSet<DecoderKey>(keys);
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(this.keys);
    }

    public R decode(Map<String, String> parameters) throws DecodingException {
        if (parameters == null) {
            throw new DecodingException("The request does not contain any parameter!", new Object[0]);
        }
        CompositeException exceptions = new CompositeException();
        OwsServiceRequest request = (OwsServiceRequest)this.supplier.get();
        parameters.forEach(exceptions.wrapConsumer(this.getDecoder(new Builder().add(this::getCommonRequestParameterDefinitions).add(this::getRequestParameterDefinitions).build()).curryFirst((Object)request)));
        if (exceptions.hasExceptions()) {
            throw new DecodingException((Throwable)exceptions);
        }
        return (R)request;
    }

    protected void getCommonRequestParameterDefinitions(Builder<R> builder) {
        builder.add((Enum<?>)OWSConstants.RequestParams.service, (ThrowingBiConsumer<R, String, DecodingException>)((ThrowingBiConsumer)OwsServiceCommunicationObject::setService));
        builder.add((Enum<?>)OWSConstants.RequestParams.version, (ThrowingBiConsumer<R, String, DecodingException>)((ThrowingBiConsumer)OwsServiceCommunicationObject::setVersion));
        builder.add((Enum<?>)OWSConstants.RequestParams.request, (ThrowingBiConsumer<R, String, DecodingException>)((ThrowingBiConsumer)OwsServiceCommunicationObject::setOperationName));
    }

    protected List<String> decodeList(String value) {
        return value == null ? null : StringHelper.splitToList((String)value, (String)",");
    }

    protected ThrowingBiConsumer<R, String, DecodingException> decodeList(ThrowingBiConsumer<? super R, ? super List<String>, DecodingException> delegate) {
        return (request, value) -> delegate.accept(request, this.decodeList((String)value));
    }

    protected ThrowingTriConsumer<R, String, String, DecodingException> decodeList(ThrowingTriConsumer<? super R, ? super String, ? super List<String>, DecodingException> delegate) {
        return (request, name, value) -> delegate.accept(request, name, this.decodeList((String)value));
    }

    protected <T> ThrowingBiConsumer<R, T, DecodingException> asList(ThrowingBiConsumer<? super R, ? super List<T>, DecodingException> delegate) {
        return (request, value) -> delegate.accept(request, Collections.singletonList(value));
    }

    protected ThrowingBiConsumer<R, String, DecodingException> normalizeMediaType(ThrowingBiConsumer<? super R, ? super String, DecodingException> delegate) {
        return (request, value) -> delegate.accept(request, (Object)MediaType.normalizeString((String)value));
    }

    protected abstract void getRequestParameterDefinitions(Builder<R> var1);

    private ThrowingTriConsumer<R, String, String, DecodingException> getDecoder(Map<String, ThrowingBiConsumer<? super R, String, DecodingException>> parsers) {
        return (request, name, value) -> {
            if (!parsers.containsKey(name)) {
                throw new DecodingException(name, "The parameter '%s' is not supported by this service!", new Object[]{name});
            }
            ((ThrowingBiConsumer)parsers.get(name)).accept(request, value);
        };
    }

    protected static final class Builder<R extends OwsServiceRequest> {
        private final Map<String, ThrowingBiConsumer<? super R, String, DecodingException>> parsers = new TreeMap<String, ThrowingBiConsumer<? super R, String, DecodingException>>(String.CASE_INSENSITIVE_ORDER);

        private Builder() {
        }

        public Builder<R> add(String name, ThrowingBiConsumer<? super R, String, DecodingException> parser) {
            Objects.requireNonNull(Strings.emptyToNull((String)name));
            Objects.requireNonNull(parser);
            this.parsers.merge(name, parser, (f1, f2) -> f1.andThen(f2));
            return this;
        }

        public Builder<R> add(Enum<?> name, ThrowingBiConsumer<? super R, String, DecodingException> parser) {
            return this.add(name.name(), parser);
        }

        public Builder<R> add(String name, ThrowingTriConsumer<? super R, String, String, DecodingException> parser) {
            return this.add(name, parser.currySecond((Object)name));
        }

        public Builder<R> add(Enum<?> name, ThrowingTriConsumer<? super R, String, String, DecodingException> parser) {
            return this.add(name.name(), parser);
        }

        public Builder<R> add(Consumer<Builder<R>> consumer) {
            consumer.accept(this);
            return this;
        }

        public Map<String, ThrowingBiConsumer<? super R, String, DecodingException>> build() {
            return Collections.unmodifiableMap(this.parsers);
        }
    }
}

