/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util.http;

import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.binding.EncodingExceptionHandler;
import org.n52.iceland.coding.encode.ResponseProxy;
import org.n52.iceland.coding.encode.ResponseWriter;
import org.n52.iceland.coding.encode.ResponseWriterRepository;
import org.n52.iceland.event.events.CountingOutputStreamEvent;
import org.n52.iceland.exception.HTTPException;
import org.n52.iceland.response.ServiceResponse;
import org.n52.janmayen.event.Event;
import org.n52.janmayen.event.EventBus;
import org.n52.janmayen.http.HTTPHeaders;
import org.n52.janmayen.http.HTTPStatus;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.ows.service.ResponseFormat;
import org.n52.svalbard.encode.exception.EncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);
    private Boolean isCountingOutputStream = false;
    private EventBus eventBus;
    private ResponseWriterRepository responseWriterRepository;

    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Inject
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Inject
    public void setResponseWriterRepository(ResponseWriterRepository responseWriterRepository) {
        this.responseWriterRepository = responseWriterRepository;
    }

    public Boolean getIsCountingOutputStream() {
        return this.isCountingOutputStream;
    }

    @Setting(value="statistics.counting-outputstream")
    public void setIsCountingOutputStream(Boolean isCountingOutputStream) {
        this.isCountingOutputStream = isCountingOutputStream;
    }

    public void writeObject(HttpServletRequest request, HttpServletResponse response, MediaType contentType, Object object, EncodingExceptionHandler owserHandler) throws IOException, HTTPException {
        this.writeObject(request, response, contentType, new GenericWritable(object, contentType), owserHandler);
    }

    public void writeObject(HttpServletRequest request, HttpServletResponse response, ServiceResponse sr, EncodingExceptionHandler owserHandler) throws IOException, HTTPException {
        response.setStatus(sr.getStatus().getCode());
        sr.getHeaderMap().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
        if (!sr.isContentLess()) {
            this.writeObject(request, response, sr.getContentType(), new ServiceResponseWritable(sr), owserHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(HttpServletRequest request, HttpServletResponse response, MediaType contentType, Writable writable, EncodingExceptionHandler owserHandler) throws IOException, HTTPException {
        block13: {
            Object out = null;
            response.setContentType(writable.getEncodedContentType().toString());
            try {
                out = response.getOutputStream();
                if (HTTPHeaders.supportsGzipEncoding((HttpServletRequest)request) && writable.supportsGZip()) {
                    out = new GZIPOutputStream((OutputStream)out);
                    response.setHeader("Content-Encoding", "gzip");
                }
                if (this.isCountingOutputStream.booleanValue()) {
                    out = new CountingOutputStream((OutputStream)out);
                }
                if (writable.hasForcedHttpStatus()) {
                    response.setStatus(writable.getForcedHttpStatus().getCode());
                }
                writable.write((OutputStream)out, new ResponseProxy(response));
                ((OutputStream)out).flush();
            }
            catch (EncodingException e) {
                Object writeOwsExceptionReport = owserHandler.handleEncodingException(request, response, e);
                if (writeOwsExceptionReport == null) break block13;
                Writable owserWritable = this.getWritable(writeOwsExceptionReport, contentType);
                try {
                    owserWritable.write((OutputStream)out, new ResponseProxy(response));
                    if (out != null) {
                        ((OutputStream)out).flush();
                    }
                }
                catch (EncodingException ex) {
                    throw new HTTPException(HTTPStatus.INTERNAL_SERVER_ERROR, (Throwable)ex);
                }
            }
            finally {
                if (out instanceof CountingOutputStream) {
                    Long bytesWritten = ((CountingOutputStream)out).getCount();
                    this.eventBus.submit((Event)new CountingOutputStreamEvent(bytesWritten));
                }
                if (out != null) {
                    LOGGER.debug("Response status = " + response.getStatus());
                    ((OutputStream)out).close();
                }
            }
        }
    }

    private Writable getWritable(Object writeOwsExceptionReport, MediaType contentType) {
        if (writeOwsExceptionReport instanceof ServiceResponse) {
            return new ServiceResponseWritable((ServiceResponse)writeOwsExceptionReport);
        }
        return new GenericWritable(writeOwsExceptionReport, contentType);
    }

    public static InputStream getInputStream(HttpServletRequest req) throws IOException {
        if (HTTPHeaders.isGzipEncoded((HttpServletRequest)req)) {
            return new GZIPInputStream((InputStream)req.getInputStream());
        }
        return req.getInputStream();
    }

    private static interface Writable {
        public void write(OutputStream var1, ResponseProxy var2) throws IOException, EncodingException;

        public boolean supportsGZip();

        public MediaType getEncodedContentType();

        default public boolean hasForcedHttpStatus() {
            return false;
        }

        default public HTTPStatus getForcedHttpStatus() {
            return HTTPStatus.OK;
        }
    }

    private class GenericWritable
    implements Writable {
        private final Object object;
        private final ResponseWriter<Object> writer;

        GenericWritable(Object object, MediaType ct) {
            this.object = object;
            this.writer = HttpUtils.this.responseWriterRepository.getWriter(object.getClass());
            if (this.writer == null) {
                throw new RuntimeException("no writer for " + object.getClass() + " found!");
            }
            this.writer.setContentType(ct);
        }

        @Override
        public boolean hasForcedHttpStatus() {
            return this.writer.hasForcedHttpStatus(this.object);
        }

        @Override
        public HTTPStatus getForcedHttpStatus() {
            return this.writer.getForcedHttpStatus(this.object);
        }

        @Override
        public boolean supportsGZip() {
            return this.writer.supportsGZip(this.object);
        }

        @Override
        public void write(OutputStream out, ResponseProxy responseProxy) throws IOException, EncodingException {
            this.writer.write(this.object, out, responseProxy);
        }

        @Override
        public MediaType getEncodedContentType() {
            if (this.object instanceof ResponseFormat) {
                return this.writer.getEncodedContentType((ResponseFormat)this.object);
            }
            return this.writer.getContentType();
        }
    }

    private static class ServiceResponseWritable
    implements Writable {
        private final ServiceResponse response;

        ServiceResponseWritable(ServiceResponse response) {
            this.response = response;
        }

        @Override
        public void write(OutputStream out, ResponseProxy responseProxy) throws IOException {
            if (!(out instanceof GZIPOutputStream) && this.response.getContentLength() > -1) {
                responseProxy.setContentLength(this.response.getContentLength());
            }
            this.response.writeToOutputStream(out);
        }

        @Override
        public boolean supportsGZip() {
            return this.response.supportsGZip();
        }

        @Override
        public MediaType getEncodedContentType() {
            return this.response.getContentType();
        }
    }
}

