/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util.activation;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.n52.iceland.util.activation.ActivationInitializer;
import org.n52.iceland.util.activation.ActivationListenable;
import org.n52.iceland.util.activation.ActivationListener;
import org.n52.iceland.util.activation.ActivationSink;
import org.n52.janmayen.lifecycle.Constructable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivationRegistrator
implements Constructable {
    private static final Logger LOG = LoggerFactory.getLogger(ActivationRegistrator.class);
    private final Map<ActivationListenable, ActivationListener> listeners;
    private final Map<ActivationSink, ActivationInitializer> initializers;

    public ActivationRegistrator() {
        LOG.debug("Constructor");
        this.listeners = Maps.newHashMap();
        this.initializers = Maps.newHashMap();
    }

    public void setListeners(Map<ActivationListenable, ActivationListener> listeners) {
        Optional.ofNullable(listeners).ifPresent(this.listeners::putAll);
    }

    public void setInitializers(Map<ActivationSink, ActivationInitializer> initializers) {
        Optional.ofNullable(initializers).ifPresent(this.initializers::putAll);
    }

    public void init() {
        LOG.debug("Initializing");
        this.initializeSinks();
        this.registerListeners();
    }

    private void initializeSinks() {
        LOG.debug("Initializing sinks");
        this.initializers.forEach(ActivationRegistrator.switchParams(ActivationRegistrator.chain(ActivationRegistrator.logger(), ActivationInitializer::initialize)));
    }

    private void registerListeners() {
        LOG.debug("Registering listeners");
        this.listeners.forEach(ActivationRegistrator.chain(ActivationRegistrator.logger(), ActivationListenable::registerListener));
    }

    private static <T, U> BiConsumer<T, U> logger() {
        return (a, b) -> LOG.debug("Registering {} for {}", a, b);
    }

    private static <T, U> BiConsumer<T, U> chain(BiConsumer<T, U> first, BiConsumer<T, U> second) {
        return first.andThen(second);
    }

    private static <T, U> BiConsumer<U, T> switchParams(BiConsumer<T, U> consumer) {
        return (a, b) -> consumer.accept(b, a);
    }
}

