/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util.activation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.n52.iceland.util.activation.ActivationListener;
import org.n52.iceland.util.activation.ActivationManager;
import org.n52.iceland.util.activation.DefaultActive;

public class ActivationListeners<K>
implements ActivationManager<K> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<K, Boolean> actives;
    private final List<ActivationListener<K>> listeners = new ArrayList<ActivationListener<K>>();
    private final boolean stateForMissingKey;

    public ActivationListeners(boolean stateForMissingKey) {
        this.actives = Collections.synchronizedMap(new HashMap());
        this.stateForMissingKey = stateForMissingKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> getKeys() {
        Map<K, Boolean> map = this.actives;
        synchronized (map) {
            return new HashSet<K>(this.actives.keySet());
        }
    }

    @Override
    public boolean isActive(K key) {
        Boolean active = this.actives.get(key);
        if (active == null) {
            if (key instanceof DefaultActive) {
                return ((DefaultActive)key).isDefaultActive();
            }
            return this.stateForMissingKey;
        }
        return active;
    }

    private boolean setState(K key, boolean value) {
        Boolean old = this.actives.put(key, value);
        return old == null ? this.stateForMissingKey != value : old != value;
    }

    @Override
    public void setActive(K key, boolean value) {
        if (value) {
            this.activate(key);
        } else {
            this.deactivate(key);
        }
    }

    @Override
    public void activate(K key) {
        this.setState(key, true);
        this.lock.readLock().lock();
        try {
            this.listeners.forEach(l -> l.activated(key));
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void deactivate(K key) {
        if (this.setState(key, false)) {
            this.lock.readLock().lock();
            try {
                this.listeners.forEach(l -> l.deactivated(key));
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @Override
    public void registerListener(ActivationListener<K> listener) {
        this.lock.writeLock().lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void deregisterListener(ActivationListener<K> listener) {
        this.lock.writeLock().lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

