/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.service;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.binding.Binding;
import org.n52.iceland.binding.BindingRepository;
import org.n52.iceland.event.events.ExceptionEvent;
import org.n52.iceland.event.events.IncomingRequestEvent;
import org.n52.iceland.event.events.OutgoingResponseEvent;
import org.n52.iceland.exception.HTTPException;
import org.n52.janmayen.event.Event;
import org.n52.janmayen.event.EventBus;
import org.n52.janmayen.http.HTTPStatus;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Configurable
@Controller
@RequestMapping(value={"/service"}, consumes={"*/*"}, produces={"*/*"})
public class Service {
    public static final String REQUEST_TIMEOUT = "service.request.timeout";
    private static final String BINDING_DELETE_METHOD = "doDeleteOperation";
    private static final String BINDING_PUT_METHOD = "doPutOperation";
    private static final String BINDING_POST_METHOD = "doPostOperation";
    private static final String BINDING_GET_METHOD = "doGetOperation";
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private static final TimeLimiter TIME_LIMITER = SimpleTimeLimiter.create((ExecutorService)Executors.newCachedThreadPool());
    private static final Logger LOGGER = LoggerFactory.getLogger(Service.class);
    private Integer requestTimeout = 0;
    @Inject
    private transient BindingRepository bindingRepository;
    @Inject
    private transient EventBus serviceEventBus;

    private long logRequest(HttpServletRequest request) {
        long count = COUNTER.incrementAndGet();
        this.serviceEventBus.submit((Event)new IncomingRequestEvent(request, count));
        if (LOGGER.isDebugEnabled()) {
            Enumeration headerNames = request.getHeaderNames();
            StringBuilder headers = new StringBuilder();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                headers.append("> ").append(name).append(": ").append(request.getHeader(name)).append("\n");
            }
            LOGGER.debug("Incoming request No. {}:\n> [{} {} {}] from {} {}\n{}", new Object[]{count, request.getMethod(), request.getRequestURI(), request.getProtocol(), request.getRemoteAddr(), request.getRemoteHost(), headers});
        }
        return count;
    }

    private void logResponse(HttpServletRequest request, HttpServletResponse response, long count, Stopwatch stopwatch) {
        long elapsed = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
        this.serviceEventBus.submit((Event)new OutgoingResponseEvent(request, response, count, elapsed));
        LOGGER.debug("Outgoing response for request No. {} is committed = {} (took {} ms)", new Object[]{count, response.isCommitted(), elapsed});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.DELETE})
    public void delete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long currentCount = this.logRequest(request);
        try {
            this.getBinding(request).doDeleteOperation(request, response);
        }
        catch (HTTPException exception) {
            this.onHttpException(request, response, exception);
        }
        finally {
            this.logResponse(request, response, currentCount, stopwatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long currentCount = this.logRequest(request);
        try {
            this.getBinding(request).doGetOperation(request, response);
        }
        catch (HTTPException exception) {
            this.onHttpException(request, response, exception);
        }
        finally {
            this.logResponse(request, response, currentCount, stopwatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST})
    public void post(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long currentCount = this.logRequest(request);
        try {
            this.getBinding(request).doPostOperation(request, response);
        }
        catch (HTTPException exception) {
            this.onHttpException(request, response, exception);
        }
        finally {
            this.logResponse(request, response, currentCount, stopwatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.PUT})
    public void put(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long currentCount = this.logRequest(request);
        try {
            this.getBinding(request).doPutOperation(request, response);
        }
        catch (HTTPException exception) {
            this.onHttpException(request, response, exception);
        }
        finally {
            this.logResponse(request, response, currentCount, stopwatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.OPTIONS})
    private void options(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long currentCount = this.logRequest(request);
        Binding binding = null;
        try {
            binding = this.getBinding(request);
            binding.doOptionsOperation(request, response);
        }
        catch (HTTPException exception) {
            if (exception.getStatus() == HTTPStatus.METHOD_NOT_ALLOWED && binding != null) {
                this.doDefaultOptions(binding, request, response);
            } else {
                this.onHttpException(request, response, exception);
            }
        }
        finally {
            this.logResponse(request, response, currentCount, stopwatch);
        }
    }

    private Binding getBinding(HttpServletRequest request) throws HTTPException {
        String requestURI = request.getPathInfo();
        if (requestURI == null || requestURI.isEmpty() || requestURI.equals("/")) {
            MediaType contentType = this.getContentType(request);
            Binding binding = this.bindingRepository.getBinding(contentType.withoutParameters());
            if (binding == null) {
                if (contentType.equals((Object)MediaTypes.APPLICATION_KVP)) {
                    throw new HTTPException(HTTPStatus.METHOD_NOT_ALLOWED);
                }
                throw new HTTPException(HTTPStatus.UNSUPPORTED_MEDIA_TYPE);
            }
            if (this.requestTimeout > 0) {
                try {
                    return (Binding)TIME_LIMITER.newProxy((Object)binding, Binding.class, (long)this.requestTimeout.intValue(), TimeUnit.SECONDS);
                }
                catch (UncheckedTimeoutException ute) {
                    HTTPException httpException = new HTTPException(HTTPStatus.GATEWAY_TIME_OUT);
                    httpException.addSuppressed(ute);
                    throw httpException;
                }
            }
            return binding;
        }
        throw new HTTPException(HTTPStatus.NOT_FOUND);
    }

    private MediaType getContentType(HttpServletRequest request) throws HTTPException {
        if (request.getContentType() == null) {
            if (request.getMethod().equals("GET")) {
                return MediaTypes.APPLICATION_KVP;
            }
            throw new HTTPException(HTTPStatus.BAD_REQUEST);
        }
        try {
            return MediaType.parse((String)request.getContentType());
        }
        catch (IllegalArgumentException e) {
            throw new HTTPException(HTTPStatus.BAD_REQUEST, (Throwable)e);
        }
    }

    protected void onHttpException(HttpServletRequest request, HttpServletResponse response, HTTPException exception) throws IOException {
        this.serviceEventBus.submit((Event)new ExceptionEvent(exception));
        response.sendError(exception.getStatus().getCode(), exception.getMessage());
    }

    protected void doDefaultOptions(Binding binding, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Set<String> methods = this.getDeclaredBindingMethods(binding.getClass());
        StringBuilder allow = new StringBuilder();
        if (methods.contains(BINDING_GET_METHOD)) {
            allow.append("GET");
            allow.append(", ");
            allow.append("HEAD");
        }
        if (methods.contains(BINDING_POST_METHOD)) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append("POST");
        }
        if (methods.contains(BINDING_PUT_METHOD)) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append("PUT");
        }
        if (methods.contains(BINDING_DELETE_METHOD)) {
            if (allow.length() != 0) {
                allow.append(", ");
            }
            allow.append("DELETE");
        }
        if (allow.length() != 0) {
            allow.append(", ");
        }
        allow.append("TRACE");
        allow.append(", ");
        allow.append("OPTIONS");
        response.setHeader("Allow", allow.toString());
    }

    private Set<String> getDeclaredBindingMethods(Class<?> c) {
        if (c.equals(Binding.class)) {
            return Collections.emptySet();
        }
        Set<String> parent = this.getDeclaredBindingMethods(c.getSuperclass());
        for (Method m : c.getDeclaredMethods()) {
            parent.add(m.getName());
        }
        return parent;
    }

    @Setting(value="service.request.timeout")
    public void setRequestTimeout(Integer requestTimeout) {
        if (requestTimeout != null) {
            this.requestTimeout = requestTimeout;
        }
    }
}

