/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.ogc.ows;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.service.operator.ServiceOperatorRepository;
import org.n52.iceland.util.LocalizedLazyThreadSafeProducer;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.janmayen.i18n.LocalizedString;
import org.n52.janmayen.i18n.MultilingualString;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.OwsKeyword;
import org.n52.shetland.ogc.ows.OwsServiceIdentification;
import org.n52.shetland.util.StringHelper;

@Configurable
public class OwsServiceIdentificationFactory
extends LocalizedLazyThreadSafeProducer<OwsServiceIdentification> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String service;
    private final ServiceOperatorRepository serviceOperatorRepository;
    private MultilingualString title = new MultilingualString();
    private MultilingualString abstrakt = new MultilingualString();
    private String fees;
    private String[] keywords = EMPTY_STRING_ARRAY;
    private String[] constraints = EMPTY_STRING_ARRAY;
    private Locale defaultLocale = Locale.ENGLISH;
    private boolean showAllLanguageValues;

    public OwsServiceIdentificationFactory(String service, ServiceOperatorRepository repository) {
        this.service = service;
        this.serviceOperatorRepository = repository;
    }

    @Setting(value="i18n.showAllLanguageValues")
    public void setShowAllLanguageValues(boolean showAllLanguageValues) {
        this.showAllLanguageValues = showAllLanguageValues;
    }

    @Setting(value="i18n.defaultLanguage")
    public void setDefaultLanguage(String lang) {
        this.defaultLocale = LocaleHelper.decode((String)lang);
    }

    @Setting(value="serviceIdentification.keywords")
    public void setKeywords(String keywords) {
        this.setKeywords(StringHelper.splitToArray((String)keywords));
    }

    public void setKeywords(String[] keywords) {
        this.keywords = OwsServiceIdentificationFactory.copyOf(keywords);
        this.setRecreate();
    }

    private Set<OwsKeyword> getKeywords() {
        return Arrays.stream(this.keywords).map(OwsKeyword::new).collect(Collectors.toSet());
    }

    @Setting(value="serviceIdentification.title")
    public void setTitle(Object title) throws ConfigurationError {
        Validation.notNull((String)"Service Identification Title", (Object)title);
        if (title instanceof MultilingualString) {
            this.title = (MultilingualString)title;
        } else if (title instanceof String) {
            this.title = this.createFromString(title);
        } else {
            throw new ConfigurationError(String.format("%s is not supported as title!", title.getClass().getName()), new Object[0]);
        }
        this.setRecreate();
    }

    private MultilingualString createFromString(Object value) {
        return new MultilingualString().addLocalization(this.defaultLocale, (String)value);
    }

    @Setting(value="serviceIdentification.abstract")
    public void setAbstract(Object description) throws ConfigurationError {
        Validation.notNull((String)"Service Identification Abstract", (Object)description);
        if (description instanceof MultilingualString) {
            this.abstrakt = (MultilingualString)description;
        } else if (description instanceof String) {
            this.abstrakt = this.createFromString(description);
        } else {
            throw new ConfigurationError(String.format("%s is not supported as abstract!", description.getClass().getName()), new Object[0]);
        }
        this.setRecreate();
    }

    @Setting(value="serviceIdentification.fees")
    public void setFees(String fees) {
        this.fees = fees;
        this.setRecreate();
    }

    private Set<String> getFees() {
        return Optional.ofNullable(this.fees).map(Collections::singleton).orElseGet(Collections::emptySet);
    }

    public void setConstraints(String[] constraints) {
        this.constraints = OwsServiceIdentificationFactory.copyOf(constraints);
        this.setRecreate();
    }

    @Setting(value="serviceIdentification.accessConstraints")
    public void setConstraints(String constraints) {
        this.setConstraints(StringHelper.splitToArray((String)constraints));
    }

    @Override
    protected OwsServiceIdentification create(Locale language) throws ConfigurationError {
        return this.createFromSettings(language);
    }

    private OwsServiceIdentification createFromSettings(Locale locale) {
        Set profiles = null;
        return new OwsServiceIdentification(this.getServiceType(), this.getSupportedVersions(), profiles, this.getFees(), this.getContraints(), this.getTitle(locale), this.getAbstract(locale), this.getKeywords());
    }

    private OwsCode getServiceType() {
        return new OwsCode("OGC:" + this.service);
    }

    private Set<String> getSupportedVersions() {
        return this.serviceOperatorRepository.getSupportedVersions(this.service);
    }

    @Override
    public Set<Locale> getAvailableLocales() {
        return Stream.of(this.title, this.abstrakt).filter(Objects::nonNull).map(MultilingualString::getLocales).collect(HashSet::new, Set::addAll, Set::addAll);
    }

    private MultilingualString getAbstract(Locale locale) {
        if (this.abstrakt.hasLocale(locale)) {
            return this.abstrakt.filter(locale, this.defaultLocale, this.showAllLanguageValues);
        }
        MultilingualString multilingualString = new MultilingualString();
        for (Locale eqLocale : LocaleHelper.getEquivalents((Locale)locale)) {
            if (!this.abstrakt.hasLocale(eqLocale)) continue;
            for (LocalizedString ls : this.abstrakt.filter(eqLocale, this.defaultLocale, this.showAllLanguageValues)) {
                multilingualString.addLocalization(new LocalizedString(locale, ls.getText()));
            }
            return multilingualString;
        }
        return this.abstrakt.filter(locale, this.defaultLocale, this.showAllLanguageValues);
    }

    private MultilingualString getTitle(Locale locale) {
        if (this.title.hasLocale(locale)) {
            return this.title.filter(locale, this.defaultLocale, this.showAllLanguageValues);
        }
        MultilingualString multilingualString = new MultilingualString();
        for (Locale eqLocale : LocaleHelper.getEquivalents((Locale)locale)) {
            if (!this.title.hasLocale(eqLocale)) continue;
            for (LocalizedString ls : this.title.filter(eqLocale, this.defaultLocale, this.showAllLanguageValues)) {
                multilingualString.addLocalization(new LocalizedString(locale, ls.getText()));
            }
            return multilingualString;
        }
        return this.title.filter(locale, this.defaultLocale, this.showAllLanguageValues);
    }

    private Set<String> getContraints() {
        return new HashSet<String>(Arrays.asList(this.constraints));
    }

    private static String[] copyOf(String[] a) {
        return a == null ? EMPTY_STRING_ARRAY : Arrays.copyOf(a, a.length);
    }
}

