/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.cache.ctrl.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.inject.Inject;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.cache.ContentCache;
import org.n52.iceland.cache.ContentCachePersistenceStrategy;
import org.n52.iceland.cache.WritableContentCache;
import org.n52.janmayen.ConfigLocationProvider;
import org.n52.janmayen.lifecycle.Constructable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public abstract class AbstractPersistingCachePersistenceStrategy
implements ContentCachePersistenceStrategy,
Constructable {
    public static final String CACHE_FILE_FOLDER = "service.cacheFileFolder";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPersistingCachePersistenceStrategy.class);
    private static final String CACHE_FILE = "cache.tmp";
    private static final String TMP_PATH = "tmp";
    private static final String WEB_INF_PATH = "WEB-INF";
    private Path cacheFile;
    private ConfigLocationProvider configLocationProvider;
    private Path cacheFileFolder;

    @Inject
    public void setConfigLocationProvider(ConfigLocationProvider configLocationProvider) {
        this.configLocationProvider = configLocationProvider;
    }

    public void init() {
        block4: {
            this.cacheFile = this.getBasePath().resolve(WEB_INF_PATH).resolve(TMP_PATH).resolve(CACHE_FILE);
            try {
                Path parent = this.cacheFile.getParent();
                if (parent != null) {
                    if (!Files.isSymbolicLink(parent)) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    break block4;
                }
                throw new RuntimeException("Error while creating tmp file path.");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public Path getCacheFile() {
        return this.cacheFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<WritableContentCache> load() {
        Path file = this.getCacheFile();
        if (!Files.isReadable(file)) {
            LOGGER.debug("No cache temp file found at '{}'", (Object)file);
            return Optional.empty();
        }
        LOGGER.debug("Reading cache from temp file '{}'", (Object)file);
        try (ObjectInputStream ois = AbstractPersistingCachePersistenceStrategy.newObjectInputStream(file);){
            Optional<WritableContentCache> optional = Optional.of((WritableContentCache)ois.readObject());
            return optional;
        }
        catch (IOException | ClassNotFoundException ex) {
            LOGGER.error(String.format("Error reading cache file '%s'", file), (Throwable)ex);
            return Optional.empty();
        }
    }

    protected void persistCache(ContentCache cache) {
        if (cache == null) {
            this.remove();
            return;
        }
        Path file = this.getCacheFile();
        try (ObjectOutputStream oos = AbstractPersistingCachePersistenceStrategy.newObjectOutputStream(file);){
            LOGGER.debug("Serializing cache to {}", (Object)file);
            oos.writeObject(cache);
        }
        catch (IOException ex) {
            LOGGER.error(String.format("Error serializing cache to '%s'", file), (Throwable)ex);
        }
    }

    protected Path getBasePath() {
        return this.isSetCacheFileFolder() ? this.getCacheFileFolder().toAbsolutePath() : Paths.get((String)this.configLocationProvider.get(), new String[0]);
    }

    @Override
    public void remove() {
        Path file = this.getCacheFile();
        if (file == null) {
            return;
        }
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException ex) {
            LOGGER.error(String.format("Error deleting cache file '%s'", file), (Throwable)ex);
        }
    }

    protected Path getCacheFileFolder() {
        return this.cacheFileFolder;
    }

    @Setting(value="service.cacheFileFolder")
    public void setCacheFileFolder(File cacheFileFolder) {
        if (cacheFileFolder != null) {
            this.setCacheFileFolder(cacheFileFolder.toPath());
        }
    }

    public void setCacheFileFolder(Path cacheFileFolder) {
        this.cacheFileFolder = cacheFileFolder;
    }

    protected boolean isSetCacheFileFolder() {
        return this.cacheFileFolder != null && Files.exists(this.cacheFileFolder, new LinkOption[0]);
    }

    private static ObjectInputStream newObjectInputStream(Path file) throws IOException {
        InputStream is = Files.newInputStream(file, new OpenOption[0]);
        BufferedInputStream bis = new BufferedInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(bis);
        return ois;
    }

    private static ObjectOutputStream newObjectOutputStream(Path file) throws IOException {
        OutputStream os = Files.newOutputStream(file, StandardOpenOption.CREATE);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        return oos;
    }
}

