/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding.soap;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.iceland.binding.AbstractXmlBinding;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.binding.EncodingExceptionHandler;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.coding.encode.OwsEncodingException;
import org.n52.iceland.event.events.ExceptionEvent;
import org.n52.iceland.exception.HTTPException;
import org.n52.iceland.service.CommunicationObjectWithSoapHeader;
import org.n52.iceland.util.http.HttpUtils;
import org.n52.janmayen.event.Event;
import org.n52.janmayen.http.HTTPHeaders;
import org.n52.janmayen.http.HTTPStatus;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceRequestContext;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.soap.SoapChain;
import org.n52.shetland.w3c.soap.SoapHeader;
import org.n52.shetland.w3c.soap.SoapHelper;
import org.n52.shetland.w3c.soap.SoapRequest;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.shetland.w3c.wsa.WsaMessageIDHeader;
import org.n52.shetland.w3c.wsa.WsaReplyToHeader;
import org.n52.shetland.w3c.wsa.WsaToHeader;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;

public class SoapBinding
extends AbstractXmlBinding<SoapRequest> {
    private static final Set<BindingKey> KEYS = Collections.singleton(new MediaTypeBindingKey(MediaTypes.APPLICATION_SOAP_XML));
    private HttpUtils httpUtils;

    public Set<BindingKey> getKeys() {
        return Collections.unmodifiableSet(KEYS);
    }

    @Override
    public boolean checkOperationHttpPostSupported(OwsOperationKey k) {
        return this.hasDecoder(k, MediaTypes.TEXT_XML) || this.hasDecoder(k, MediaTypes.APPLICATION_XML);
    }

    @Override
    protected boolean isUseHttpResponseCodes() {
        return false;
    }

    @Override
    protected MediaType getDefaultContentType() {
        return MediaTypes.APPLICATION_SOAP_XML;
    }

    @Override
    public void doPostOperation(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws HTTPException, IOException {
        SoapChain chain = new SoapChain(httpRequest, httpResponse);
        try {
            this.parseSoapRequest(chain);
            this.checkForContext(chain, this.getRequestContext(httpRequest));
            this.createSoapResponse(chain);
            if (!chain.getSoapRequest().hasSoapFault()) {
                this.createBodyResponse(chain);
            }
            this.writeResponse(chain);
        }
        catch (OwsExceptionReport t) {
            this.writeOwsExceptionReport(chain, t);
        }
    }

    private void checkForContext(SoapChain chain, OwsServiceRequestContext requestContext) {
        if (chain != null) {
            if (chain.getBodyRequest() != null) {
                chain.getBodyRequest().setRequestContext(requestContext);
            }
            if (chain.getSoapRequest() != null && chain.getSoapRequest().getSoapBodyContent() != null) {
                chain.getSoapRequest().getSoapBodyContent().setRequestContext(requestContext);
            }
        }
    }

    private void parseSoapRequest(SoapChain soapChain) throws OwsExceptionReport {
        String soapAction = SoapHelper.checkSoapHeader((HttpServletRequest)soapChain.getHttpRequest());
        SoapRequest soapRequest = (SoapRequest)this.decode(soapChain.getHttpRequest());
        if (soapRequest.getSoapAction() == null && soapAction != null) {
            soapRequest.setAction(soapAction);
        }
        soapChain.setSoapRequest(soapRequest);
    }

    private void createSoapResponse(SoapChain chain) {
        SoapResponse soapResponse = new SoapResponse();
        soapResponse.setSoapVersion(chain.getSoapRequest().getSoapVersion());
        soapResponse.setSoapNamespace(chain.getSoapRequest().getSoapNamespace());
        soapResponse.setHeader(this.checkSoapHeaders(chain.getSoapRequest().getSoapHeader()));
        chain.setSoapResponse(soapResponse);
    }

    private void createBodyResponse(SoapChain chain) throws OwsExceptionReport {
        OwsServiceRequest req = chain.getSoapRequest().getSoapBodyContent();
        chain.setBodyResponse(this.getServiceOperator(req).receiveRequest(req));
    }

    private Object encodeSoapResponse(SoapChain chain) throws OwsExceptionReport, NoEncoderForKeyException {
        XmlEncoderKey key = new XmlEncoderKey(chain.getSoapResponse().getSoapNamespace(), chain.getSoapResponse().getClass());
        Encoder encoder = this.getEncoder((EncoderKey)key);
        if (encoder != null) {
            try {
                return encoder.encode((Object)chain.getSoapResponse());
            }
            catch (OwsEncodingException ex) {
                throw ex.getCause();
            }
            catch (EncodingException ex) {
                throw new NoApplicableCodeException().withMessage(ex.getMessage(), new Object[0]).causedBy((Throwable)ex);
            }
        }
        NoEncoderForKeyException cause = new NoEncoderForKeyException((Object)key);
        throw new NoApplicableCodeException().withMessage(cause.getMessage(), new Object[0]).causedBy((Throwable)cause);
    }

    private void writeOwsExceptionReport(SoapChain chain, OwsExceptionReport owse) throws HTTPException, IOException {
        try {
            String version = chain.hasBodyRequest() ? chain.getBodyRequest().getVersion() : null;
            this.getEventBus().submit((Event)new ExceptionEvent((Exception)((Object)owse)));
            chain.getSoapResponse().setException(owse.setVersion(version));
            if (!chain.getSoapResponse().hasSoapVersion()) {
                chain.getSoapResponse().setSoapVersion("SOAP 1.2 Protocol");
            }
            if (!chain.getSoapResponse().hasSoapNamespace()) {
                chain.getSoapResponse().setSoapNamespace("http://www.w3.org/2003/05/soap-envelope");
            }
            if (chain.getSoapResponse().hasException() && chain.getSoapResponse().getException().hasStatus()) {
                chain.getHttpResponse().setStatus(chain.getSoapResponse().getException().getStatus().getCode());
            }
            this.checkSoapInjection(chain);
            this.httpUtils.writeObject(chain.getHttpRequest(), chain.getHttpResponse(), this.checkMediaType(chain), this.encodeSoapResponse(chain), (EncodingExceptionHandler)this);
        }
        catch (OwsExceptionReport | NoEncoderForKeyException t) {
            throw new HTTPException(HTTPStatus.INTERNAL_SERVER_ERROR, t);
        }
    }

    private void writeResponse(SoapChain chain) throws IOException, HTTPException {
        MediaType contentType = this.chooseResponseContentType(chain.getBodyResponse(), HTTPHeaders.getAcceptHeader((HttpServletRequest)chain.getHttpRequest()), this.getDefaultContentType());
        if (contentType.isCompatible(this.getDefaultContentType())) {
            this.checkSoapInjection(chain);
            this.httpUtils.writeObject(chain.getHttpRequest(), chain.getHttpResponse(), this.checkMediaType(chain), chain, (EncodingExceptionHandler)this);
        } else {
            this.httpUtils.writeObject(chain.getHttpRequest(), chain.getHttpResponse(), contentType, chain.getBodyResponse(), (EncodingExceptionHandler)this);
        }
    }

    private MediaType checkMediaType(SoapChain chain) {
        GetCapabilitiesRequest r;
        if (chain.getBodyRequest() instanceof GetCapabilitiesRequest && (r = (GetCapabilitiesRequest)chain.getBodyRequest()).isSetAcceptFormats()) {
            return MediaType.parse((String)((String)r.getAcceptFormats().get(0)));
        }
        return MediaTypes.APPLICATION_SOAP_XML;
    }

    private void checkSoapInjection(SoapChain chain) {
        CommunicationObjectWithSoapHeader soapHeaderObject;
        if (chain.getBodyResponse() instanceof CommunicationObjectWithSoapHeader && (soapHeaderObject = (CommunicationObjectWithSoapHeader)chain.getBodyResponse()).isSetSoapHeader()) {
            List<SoapHeader> headers = ((CommunicationObjectWithSoapHeader)chain.getSoapRequest()).getSoapHeader();
            chain.getSoapResponse().setHeader(this.checkSoapHeaders(headers));
        }
    }

    private List<SoapHeader> checkSoapHeaders(List<SoapHeader> headers) {
        if (CollectionHelper.isNotEmpty(headers)) {
            return headers.stream().map(header -> {
                if (header instanceof WsaMessageIDHeader) {
                    return ((WsaMessageIDHeader)header).getRelatesToHeader();
                }
                if (header instanceof WsaReplyToHeader) {
                    return ((WsaReplyToHeader)header).getToHeader();
                }
                if (!(header instanceof WsaToHeader)) {
                    return header;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    @Override
    @Inject
    public void setHttpUtils(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }
}

