/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding.pox;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.binding.AbstractXmlBinding;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.exception.HTTPException;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public class PoxBinding
extends AbstractXmlBinding<OwsServiceRequest> {
    private static final Set<BindingKey> KEYS = ImmutableSet.builder().add((Object)new MediaTypeBindingKey(MediaTypes.APPLICATION_XML)).add((Object)new MediaTypeBindingKey(MediaTypes.TEXT_XML)).build();
    private static final Logger LOG = LoggerFactory.getLogger(PoxBinding.class);
    private boolean useHttpResponseCodes;

    @Setting(value="misc.httpResponseCodeUseInKvpAndPoxBinding")
    public void setUseHttpResponseCodes(boolean useHttpResponseCodes) {
        this.useHttpResponseCodes = useHttpResponseCodes;
    }

    @Override
    protected boolean isUseHttpResponseCodes() {
        return this.useHttpResponseCodes;
    }

    public Set<BindingKey> getKeys() {
        return Collections.unmodifiableSet(KEYS);
    }

    @Override
    public void doPostOperation(HttpServletRequest req, HttpServletResponse res) throws HTTPException, IOException {
        OwsServiceRequest request = null;
        try {
            request = this.parseRequest(req);
            OwsServiceResponse response = this.getServiceOperator(request).receiveRequest(request);
            this.writeResponse(req, res, response);
        }
        catch (OwsExceptionReport oer) {
            oer.setVersion(request != null ? request.getVersion() : null);
            LOG.warn("Unexpected error", (Throwable)oer);
            this.writeOwsExceptionReport(req, res, oer);
        }
    }

    protected OwsServiceRequest parseRequest(HttpServletRequest request) throws OwsExceptionReport {
        return ((OwsServiceRequest)this.decode(request)).setRequestContext(this.getRequestContext(request));
    }

    @Override
    public boolean checkOperationHttpPostSupported(OwsOperationKey k) {
        return this.hasDecoder(k, MediaTypes.TEXT_XML) || this.hasDecoder(k, MediaTypes.APPLICATION_XML);
    }

    @Override
    protected MediaType getDefaultContentType() {
        return MediaTypes.APPLICATION_XML;
    }
}

