/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.iceland.binding.Binding;
import org.n52.iceland.binding.EncodingExceptionHandler;
import org.n52.iceland.coding.encode.OwsEncodingException;
import org.n52.iceland.event.events.ExceptionEvent;
import org.n52.iceland.exception.HTTPException;
import org.n52.iceland.exception.ows.concrete.InvalidAcceptVersionsParameterException;
import org.n52.iceland.exception.ows.concrete.InvalidServiceOrVersionException;
import org.n52.iceland.exception.ows.concrete.InvalidServiceParameterException;
import org.n52.iceland.exception.ows.concrete.VersionNotSupportedException;
import org.n52.iceland.service.operator.ServiceOperator;
import org.n52.iceland.service.operator.ServiceOperatorRepository;
import org.n52.iceland.util.http.HttpUtils;
import org.n52.janmayen.Comparables;
import org.n52.janmayen.event.Event;
import org.n52.janmayen.event.EventBus;
import org.n52.janmayen.http.HTTPHeaders;
import org.n52.janmayen.http.HTTPStatus;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.ows.exception.MissingServiceParameterException;
import org.n52.shetland.ogc.ows.exception.MissingVersionParameterException;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceRequestContext;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.DecoderRepository;
import org.n52.svalbard.decode.OperationDecoderKey;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncoderRepository;
import org.n52.svalbard.encode.ExceptionEncoderKey;
import org.n52.svalbard.encode.OperationResponseEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleBinding
implements Binding {
    private static final String HTTP_MEDIA_TYPE_QUALITY_PARAM = "q";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleBinding.class);
    private EventBus eventBus;
    private ServiceOperatorRepository serviceOperatorRepository;
    private EncoderRepository encoderRepository;
    private DecoderRepository decoderRepository;
    private HttpUtils httpUtils;

    public HttpUtils getHttpUtils() {
        return this.httpUtils;
    }

    @Inject
    public void setHttpUtils(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    @Inject
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Inject
    public void setServiceOperatorRepository(ServiceOperatorRepository repo) {
        this.serviceOperatorRepository = repo;
    }

    public ServiceOperatorRepository getServiceOperatorRepository() {
        return this.serviceOperatorRepository;
    }

    @Inject
    public void setEncoderRepository(EncoderRepository encoderRepository) {
        this.encoderRepository = encoderRepository;
    }

    public EncoderRepository getEncoderRepository() {
        return this.encoderRepository;
    }

    @Inject
    public void setDecoderRepository(DecoderRepository decoderRepository) {
        this.decoderRepository = decoderRepository;
    }

    public DecoderRepository getDecoderRepository() {
        return this.decoderRepository;
    }

    @Override
    public Object handleEncodingException(HttpServletRequest request, HttpServletResponse response, EncodingException ex) throws HTTPException {
        try {
            OwsExceptionReport oer = ex instanceof OwsEncodingException ? ((OwsEncodingException)ex).getCause() : (ex.getCause() instanceof OwsExceptionReport ? (OwsExceptionReport)ex.getCause() : new NoApplicableCodeException().withMessage(ex.getMessage(), new Object[0]).causedBy((Throwable)ex));
            this.eventBus.submit((Event)new ExceptionEvent((Exception)((Object)oer)));
            MediaType contentType = this.chooseResponseContentTypeForExceptionReport(HTTPHeaders.getAcceptHeader((HttpServletRequest)request), this.getDefaultContentType());
            Object encoded = this.encodeOwsExceptionReport(oer, contentType);
            if (this.isUseHttpResponseCodes() && oer.hasStatus()) {
                response.setStatus(oer.getStatus().getCode());
            }
            return encoded;
        }
        catch (OwsExceptionReport e) {
            throw new HTTPException(HTTPStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    protected abstract boolean isUseHttpResponseCodes();

    protected OwsServiceRequestContext getRequestContext(HttpServletRequest req) {
        return OwsServiceRequestContext.fromRequest((HttpServletRequest)req);
    }

    protected boolean isVersionSupported(String service, String acceptVersion) {
        return this.getServiceOperatorRepository().isVersionSupported(service, acceptVersion);
    }

    protected boolean isServiceSupported(String service) {
        return this.getServiceOperatorRepository().isServiceSupported(service);
    }

    protected <F, T> Decoder<F, T> getDecoder(DecoderKey key) {
        return this.decoderRepository.getDecoder(key, new DecoderKey[0]);
    }

    protected <F, T> Encoder<F, T> getEncoder(EncoderKey key) {
        return this.encoderRepository.getEncoder(key, new EncoderKey[0]);
    }

    protected boolean hasDecoder(DecoderKey key) {
        return this.decoderRepository.hasDecoder(key, new DecoderKey[0]);
    }

    protected boolean hasDecoder(OwsOperationKey key, MediaType mediaType) {
        return this.hasDecoder((DecoderKey)new OperationDecoderKey(key, mediaType));
    }

    protected boolean hasEncoder(EncoderKey key) {
        return this.encoderRepository.hasEncoder(key, new EncoderKey[0]);
    }

    protected boolean hasEncoder(OwsOperationKey key, MediaType mediaType) {
        return this.hasEncoder((EncoderKey)new OperationResponseEncoderKey(key, mediaType));
    }

    protected boolean hasEncoder(OwsServiceResponse response, MediaType mediaType) {
        return this.hasEncoder(new OwsOperationKey((OwsServiceCommunicationObject)response), mediaType);
    }

    protected MediaType chooseResponseContentType(OwsServiceResponse response, List<MediaType> acceptHeader, MediaType defaultContentType) throws HTTPException {
        if (!acceptHeader.isEmpty()) {
            if (!response.isSetContentType()) {
                for (MediaType mt : acceptHeader) {
                    MediaType mediaType = mt.withoutParameter(HTTP_MEDIA_TYPE_QUALITY_PARAM);
                    if (defaultContentType.isCompatible(mediaType)) {
                        return defaultContentType;
                    }
                    if (!this.hasEncoder(response, mediaType)) continue;
                    return mediaType;
                }
                throw new HTTPException(HTTPStatus.NOT_ACCEPTABLE);
            }
            for (MediaType mt : acceptHeader) {
                MediaType mediaType = mt.withoutParameter(HTTP_MEDIA_TYPE_QUALITY_PARAM);
                if (!response.getContentType().isCompatible(mediaType)) continue;
                return response.getContentType();
            }
            throw new HTTPException(HTTPStatus.NOT_ACCEPTABLE);
        }
        if (!response.isSetContentType()) {
            return defaultContentType;
        }
        MediaType mediaType = response.getContentType().withoutParameter(HTTP_MEDIA_TYPE_QUALITY_PARAM);
        if (this.hasEncoder(response, mediaType)) {
            return mediaType;
        }
        throw new HTTPException(HTTPStatus.NOT_ACCEPTABLE);
    }

    protected MediaType chooseResponseContentTypeForExceptionReport(List<MediaType> acceptHeader, MediaType defaultContentType) throws HTTPException {
        if (acceptHeader.isEmpty()) {
            return defaultContentType;
        }
        for (MediaType mt : acceptHeader) {
            MediaType mediaType = mt.withoutParameter(HTTP_MEDIA_TYPE_QUALITY_PARAM);
            if (defaultContentType.isCompatible(mediaType)) {
                return defaultContentType;
            }
            if (!this.hasEncoder((EncoderKey)new ExceptionEncoderKey(mediaType))) continue;
            return mediaType;
        }
        throw new HTTPException(HTTPStatus.NOT_ACCEPTABLE);
    }

    protected ServiceOperator getServiceOperator(OwsServiceKey sokt) {
        return this.getServiceOperatorRepository().getServiceOperator(sokt);
    }

    protected ServiceOperator getServiceOperator(OwsServiceRequest request) throws OwsExceptionReport {
        this.checkServiceOperatorKeyTypes(request);
        String service = request.getService();
        String version = request.getVersion();
        if (request instanceof GetCapabilitiesRequest) {
            GetCapabilitiesRequest gcr = (GetCapabilitiesRequest)request;
            if (gcr.isSetAcceptVersions()) {
                return gcr.getAcceptVersions().stream().map(v -> new OwsServiceKey(service, v)).map(this::getServiceOperator).filter(Objects::nonNull).findFirst().orElseThrow(() -> new InvalidServiceOrVersionException(service, version));
            }
            Set<String> supportedVersions = this.serviceOperatorRepository.getSupportedVersions(service);
            String newest = (String)supportedVersions.stream().max(Comparables.version()).orElseThrow(() -> new InvalidServiceParameterException(service));
            return this.getServiceOperator(new OwsServiceKey(service, newest));
        }
        return this.getServiceOperator(new OwsServiceKey(service, version));
    }

    protected void checkServiceOperatorKeyTypes(OwsServiceRequest request) throws OwsExceptionReport {
        String service = request.getService();
        String version = request.getVersion();
        if (service == null || service.isEmpty()) {
            throw new MissingServiceParameterException();
        }
        if (!this.getServiceOperatorRepository().isServiceSupported(service)) {
            throw new InvalidServiceParameterException(service);
        }
        if (request instanceof GetCapabilitiesRequest) {
            GetCapabilitiesRequest gcr = (GetCapabilitiesRequest)request;
            if (gcr.isSetAcceptVersions() && !gcr.getAcceptVersions().stream().anyMatch(v -> this.isVersionSupported(service, (String)v))) {
                throw new InvalidAcceptVersionsParameterException(gcr.getAcceptVersions());
            }
        } else {
            if (version == null || version.isEmpty()) {
                throw new MissingVersionParameterException();
            }
            if (!this.isVersionSupported(service, version)) {
                throw new VersionNotSupportedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, OwsServiceResponse serviceResponse) throws HTTPException, IOException {
        try {
            MediaType contentType = this.chooseResponseContentType(serviceResponse, HTTPHeaders.getAcceptHeader((HttpServletRequest)request), this.getDefaultContentType());
            if (!serviceResponse.isSetContentType()) {
                serviceResponse.setContentType(contentType);
            }
            this.httpUtils.writeObject(request, response, contentType, serviceResponse, (EncodingExceptionHandler)this);
        }
        finally {
            serviceResponse.close();
        }
    }

    protected Object encodeResponse(OwsServiceResponse response, MediaType contentType) throws OwsExceptionReport {
        try {
            OperationResponseEncoderKey key = new OperationResponseEncoderKey(new OwsOperationKey((OwsServiceCommunicationObject)response), contentType);
            Encoder encoder = this.getEncoder((EncoderKey)key);
            if (encoder == null) {
                throw new NoEncoderForKeyException((Object)key);
            }
            return encoder.encode((Object)response);
        }
        catch (EncodingException ex) {
            throw new NoApplicableCodeException().withMessage(ex.getMessage(), new Object[0]).causedBy((Throwable)ex);
        }
    }

    protected void writeOwsExceptionReport(HttpServletRequest request, HttpServletResponse response, OwsExceptionReport oer) throws HTTPException {
        try {
            this.eventBus.submit((Event)new ExceptionEvent((Exception)((Object)oer)));
            MediaType contentType = this.chooseResponseContentTypeForExceptionReport(HTTPHeaders.getAcceptHeader((HttpServletRequest)request), this.getDefaultContentType());
            Object encoded = this.encodeOwsExceptionReport(oer, contentType);
            if (this.isUseHttpResponseCodes() && oer.hasStatus()) {
                response.setStatus(oer.getStatus().getCode());
            }
            this.httpUtils.writeObject(request, response, contentType, encoded, (EncodingExceptionHandler)this);
        }
        catch (IOException | OwsExceptionReport e) {
            throw new HTTPException(HTTPStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    protected abstract MediaType getDefaultContentType();

    protected Object encodeOwsExceptionReport(OwsExceptionReport oer, MediaType contentType) throws OwsExceptionReport, HTTPException {
        Encoder encoder = this.getEncoder((EncoderKey)new ExceptionEncoderKey(contentType));
        if (encoder == null) {
            LOG.error("Can't find OwsExceptionReport encoder for Content-Type {}", (Object)contentType);
            throw new HTTPException(HTTPStatus.UNSUPPORTED_MEDIA_TYPE);
        }
        try {
            return encoder.encode((Object)oer);
        }
        catch (EncodingException ex) {
            throw new NoApplicableCodeException().withMessage(ex.getMessage(), new Object[0]).causedBy((Throwable)ex);
        }
    }
}

