/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.n52.iceland.binding.Binding;
import org.n52.iceland.binding.BindingFactory;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.binding.PathBindingKey;
import org.n52.iceland.util.activation.Activatables;
import org.n52.iceland.util.activation.ActivationListener;
import org.n52.iceland.util.activation.ActivationListeners;
import org.n52.iceland.util.activation.ActivationManager;
import org.n52.iceland.util.activation.ActivationSource;
import org.n52.janmayen.Producer;
import org.n52.janmayen.Producers;
import org.n52.janmayen.component.AbstractComponentRepository;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.lifecycle.Constructable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingRepository
extends AbstractComponentRepository<BindingKey, Binding, BindingFactory>
implements ActivationManager<BindingKey>,
ActivationSource<BindingKey>,
Constructable {
    private static final Logger LOG = LoggerFactory.getLogger(BindingRepository.class);
    private final ActivationListeners<BindingKey> activation = new ActivationListeners(true);
    private final Map<BindingKey, Producer<Binding>> bindings = Maps.newHashMap();
    private Optional<Collection<Binding>> components;
    private Optional<Collection<BindingFactory>> componentFactories;

    @Inject
    public void setComponentFactories(Optional<Collection<BindingFactory>> componentFactories) {
        this.componentFactories = componentFactories;
    }

    @Inject
    public void setComponents(Optional<Collection<Binding>> components) {
        this.components = components;
    }

    @Override
    public void registerListener(ActivationListener<BindingKey> listener) {
        this.activation.registerListener(listener);
    }

    @Override
    public void deregisterListener(ActivationListener<BindingKey> listener) {
        this.activation.deregisterListener(listener);
    }

    @Override
    public boolean isActive(BindingKey key) {
        return this.activation.isActive(key);
    }

    @Override
    public boolean isActive(String urlPattern) {
        return this.isActive(new PathBindingKey(urlPattern));
    }

    @Override
    public boolean isActive(MediaType mediaType) {
        return this.isActive(new MediaTypeBindingKey(mediaType));
    }

    @Override
    public void activate(BindingKey key) {
        this.activation.activate(key);
    }

    @Override
    public void deactivate(BindingKey key) {
        this.activation.deactivate(key);
    }

    @Override
    public Set<BindingKey> getKeys() {
        return Collections.unmodifiableSet(this.bindings.keySet());
    }

    @Override
    public void setActive(BindingKey bk, boolean active) {
        this.activation.setActive(bk, active);
    }

    public void init() {
        Map implementations = this.getUniqueProviders(this.components, this.componentFactories);
        this.bindings.clear();
        for (Map.Entry entry : implementations.entrySet()) {
            BindingKey key = (BindingKey)entry.getKey();
            Producer binding = (Producer)entry.getValue();
            this.bindings.put(key, (Producer<Binding>)binding);
        }
        if (this.bindings.isEmpty()) {
            StringBuilder exceptionText = new StringBuilder();
            exceptionText.append("No Binding implementation could be loaded! ");
            exceptionText.append("If the service is not used as a webapp, this has no effect! ");
            exceptionText.append("Please add a Binding implementation!");
            LOG.warn(exceptionText.toString());
        }
    }

    public Binding getBinding(String urlPattern) {
        return this.getBinding(new PathBindingKey(urlPattern));
    }

    public Binding getBinding(MediaType mediaType) {
        return this.getBinding(new MediaTypeBindingKey(mediaType));
    }

    public Binding getBinding(BindingKey key) {
        Producer<Binding> binding = this.bindings.get(key);
        return binding == null ? null : (Binding)binding.get();
    }

    public boolean isBindingSupported(String urlPattern) {
        return this.isActive(new PathBindingKey(urlPattern));
    }

    public boolean isBindingSupported(MediaType mediaType) {
        return this.isActive(new MediaTypeBindingKey(mediaType));
    }

    public boolean isBindingSupported(BindingKey key) {
        return this.isActive(key);
    }

    public Map<BindingKey, Binding> getBindings() {
        Map<BindingKey, Producer<Binding>> actives = Activatables.activatedMap(this.bindings, this.activation);
        return Producers.produce(actives);
    }

    public Map<MediaType, Binding> getBindingsByMediaType() {
        HashMap<MediaType, Binding> map = new HashMap<MediaType, Binding>(this.bindings.size());
        for (Map.Entry<BindingKey, Producer<Binding>> entry : this.bindings.entrySet()) {
            if (!(entry.getKey() instanceof MediaTypeBindingKey)) continue;
            MediaTypeBindingKey key = (MediaTypeBindingKey)entry.getKey();
            Producer<Binding> producer = entry.getValue();
            if (!this.isActive(key)) continue;
            map.put(key.getMediaType(), (Binding)producer.get());
        }
        return map;
    }

    public Map<MediaType, Binding> getAllBindingsByMediaType() {
        HashMap<MediaType, Binding> map = new HashMap<MediaType, Binding>(this.bindings.size());
        for (Map.Entry<BindingKey, Producer<Binding>> entry : this.bindings.entrySet()) {
            if (!(entry.getKey() instanceof MediaTypeBindingKey)) continue;
            MediaTypeBindingKey key = (MediaTypeBindingKey)entry.getKey();
            Producer<Binding> producer = entry.getValue();
            map.put(key.getMediaType(), (Binding)producer.get());
        }
        return map;
    }
}

