/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.n52.iceland.exception.ows.concrete.GenericThrowableWrapperException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;

public final class FileIOHelper {
    private static final byte LINE_FEED = 10;
    private static final byte CARRIAGE_RETURN = 13;
    private static final String READ_MODE = "r";

    private FileIOHelper() {
    }

    @Deprecated
    public static InputStream loadInputStreamFromFile(File file) throws OwsExceptionReport {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new GenericThrowableWrapperException(fnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> tail(File file, int lines) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, READ_MODE);){
            long length = file.length() - 1L;
            ArrayList<String> out = new ArrayList<String>(lines);
            StringBuilder sb = new StringBuilder();
            int prev = -1;
            for (long pos = length; pos != -1L; --pos) {
                raf.seek(pos);
                byte b = raf.readByte();
                try {
                    if (b == 13) continue;
                    if (b == 10) {
                        if (pos == length || pos == length - 1L || prev == 13) continue;
                        out.add(sb.reverse().toString());
                        sb = null;
                        if (out.size() == lines) break;
                        sb = new StringBuilder();
                        continue;
                    }
                    sb.append((char)b);
                    continue;
                }
                finally {
                    prev = b;
                }
            }
            if (sb != null) {
                out.add(sb.reverse().toString());
            }
            Collections.reverse(out);
            ArrayList<String> arrayList = out;
            return arrayList;
        }
    }
}

