/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.coding.encode;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.n52.iceland.coding.encode.ResponseWriter;
import org.n52.iceland.coding.encode.ResponseWriterFactory;
import org.n52.iceland.coding.encode.ResponseWriterKey;
import org.n52.janmayen.ClassHelper;
import org.n52.janmayen.Comparables;
import org.n52.janmayen.Producer;
import org.n52.janmayen.component.AbstractComponentRepository;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.shetland.util.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class ResponseWriterRepository
extends AbstractComponentRepository<ResponseWriterKey, ResponseWriter<?>, ResponseWriterFactory>
implements Constructable {
    @Deprecated
    private static ResponseWriterRepository instance;
    private final Map<ResponseWriterKey, Producer<ResponseWriter<?>>> writersByClass = CollectionHelper.synchronizedMap();
    @Autowired(required=false)
    private Optional<Collection<ResponseWriter<?>>> components = Optional.empty();
    @Autowired(required=false)
    private Optional<Collection<ResponseWriterFactory>> componentFactories = Optional.empty();

    public void init() {
        this.setStaticInstance();
        Map implementations = this.getUniqueProviders(this.components, this.componentFactories);
        this.writersByClass.clear();
        this.writersByClass.putAll(implementations);
    }

    public <T> ResponseWriter<T> getWriter(Class<? extends T> clazz) {
        ResponseWriterKey key = new ResponseWriterKey(clazz);
        if (!this.writersByClass.containsKey((Object)key)) {
            HashSet compatible = Sets.newHashSet();
            for (ResponseWriterKey c : this.writersByClass.keySet()) {
                if (ClassHelper.getSimiliarity((Class)c.getType(), clazz) < 0) continue;
                compatible.add(c.getType());
            }
            this.writersByClass.put(key, this.writersByClass.get((Object)this.chooseWriter(compatible, clazz)));
        }
        Producer<ResponseWriter<?>> producer = this.writersByClass.get((Object)key);
        return Optional.ofNullable(producer).map(Producer::get).orElse(null);
    }

    private ResponseWriterKey chooseWriter(Set<Class<?>> compatible, Class<?> clazz) {
        if (compatible.isEmpty()) {
            return null;
        }
        ClassSimilarityComparator comparator = new ClassSimilarityComparator(clazz);
        return new ResponseWriterKey(Collections.min(compatible, comparator));
    }

    @Deprecated
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    private void setStaticInstance() {
        instance = this;
    }

    @Deprecated
    public static ResponseWriterRepository getInstance() {
        return instance;
    }

    private static class ClassSimilarityComparator
    implements Serializable,
    Comparator<Class<?>> {
        private static final long serialVersionUID = -377524541804891733L;
        private final Class<?> reference;

        ClassSimilarityComparator(Class<?> reference) {
            this.reference = reference;
        }

        @Override
        public int compare(Class<?> c1, Class<?> c2) {
            return Comparables.compare((int)ClassHelper.getSimiliarity(c1, this.reference), (int)ClassHelper.getSimiliarity(c2, this.reference));
        }
    }
}

