/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding.exi;

import com.siemens.ct.exi.core.CodingMode;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.FidelityOptions;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.exceptions.UnsupportedOption;
import com.siemens.ct.exi.core.grammars.Grammars;
import com.siemens.ct.exi.core.helpers.DefaultEXIFactory;
import com.siemens.ct.exi.grammars.GrammarFactory;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.janmayen.Producer;
import org.n52.janmayen.lifecycle.Constructable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public class EXIUtils
implements Constructable,
Producer<EXIFactory> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EXIUtils.class);
    private boolean isSchemaLessGrammar;
    private boolean isXSBaseTypeGrammar;
    private boolean isSOS20Schema;
    private boolean isSOS10Schema;
    private CodingMode alignment = CodingMode.BIT_PACKED;
    private boolean isStrict;
    private boolean isDefault;
    private boolean preserveComments;
    private boolean preserveProcessingInstructions;
    private boolean preserveDTD;
    private boolean preservePrefixes;
    private boolean preserveLexicalValue;
    private final GrammarFactory grammarFactory = GrammarFactory.newInstance();
    private final Grammars grammarSchemaLess = this.grammarFactory.createSchemaLessGrammars();
    private Grammars grammarSos20;
    private Grammars grammarSos10;
    private Grammars grammarBaseTypes;

    public void init() {
        try {
            if (!this.isSchemaLessGrammar()) {
                if (this.isXSBaseTypeGrammar()) {
                    this.grammarBaseTypes = this.grammarFactory.createXSDTypesOnlyGrammars();
                } else if (this.isSOS10Schema()) {
                    this.grammarSos10 = this.grammarFactory.createGrammars("http://schemas.opengis.net/sos/1.0.0/sosAll.xsd");
                } else if (this.isSOS20Schema()) {
                    this.grammarSos20 = this.grammarFactory.createGrammars("http://schemas.opengis.net/sos/2.0/sos.xsd");
                }
            }
        }
        catch (EXIException e) {
            LOGGER.error("Could not load XSD schema for EXI binding. Using default schema less grammar. Please update your settings.", (Throwable)e);
        }
    }

    @Setting(value="exi.fidelity.lexical.value")
    public void setFidelityLexicalValue(boolean preserveLexicalValue) {
        this.preserveLexicalValue = preserveLexicalValue;
    }

    @Setting(value="exi.fidelity.prefixes")
    public void setFidelityPrefixes(boolean preservePrefixes) {
        this.preservePrefixes = preservePrefixes;
    }

    @Setting(value="exi.fidelity.dtd")
    public void setFidelityDTD(boolean preserveDTD) {
        this.preserveDTD = preserveDTD;
    }

    @Setting(value="exi.fidelity.processing.instructions")
    public void setFidelityProcessingInstructions(boolean preserveProcessingInstructions) {
        this.preserveProcessingInstructions = preserveProcessingInstructions;
    }

    @Setting(value="exi.fidelity.comments")
    public void setFidelityComments(boolean preserveComments) {
        this.preserveComments = preserveComments;
    }

    @Setting(value="exi.fidelity")
    public void setStrictFidelity(String fidelity) {
        Validation.notNullOrEmpty((String)"exi.fidelity", (String)fidelity);
        if (fidelity.equalsIgnoreCase("exi.fidelity.strict")) {
            this.isStrict = true;
        } else if (fidelity.equalsIgnoreCase("exi.fidelity.default")) {
            this.isDefault = true;
        }
    }

    @Setting(value="exi.alignment")
    public void setCodingMode(String codingMode) {
        Validation.notNullOrEmpty((String)"exi.alignment", (String)codingMode);
        this.alignment = CodingMode.valueOf((String)codingMode);
    }

    @Setting(value="exi.grammar")
    public void setGrammarType(String grammar) {
        Validation.notNullOrEmpty((String)"exi.grammar", (String)grammar);
        if (grammar.equalsIgnoreCase("exi.grammar.schemaless")) {
            this.setSchemaLessGrammar(true);
        } else if (grammar.equalsIgnoreCase("exi.grammar.basetypes")) {
            this.setXSBaseTypeGrammar(true);
        }
    }

    @Setting(value="exi.grammar.schema")
    public void setGrammarSchema(String grammarSchema) {
        Validation.notNullOrEmpty((String)"exi.grammar.schema", (String)grammarSchema);
        if (grammarSchema.equalsIgnoreCase("exi.grammar.schema.sos.20")) {
            this.setSOS20Schema(true);
        } else if (grammarSchema.equalsIgnoreCase("exi.grammar.schema.sos.10")) {
            this.setSOS10Schema(true);
        }
    }

    public EXIFactory get() {
        try {
            return this.newEXIFactory();
        }
        catch (UnsupportedOption ex) {
            throw new RuntimeException(ex);
        }
    }

    public EXIFactory newEXIFactory() throws UnsupportedOption {
        EXIFactory factory = DefaultEXIFactory.newInstance();
        factory.setGrammars(this.getGrammars());
        if (this.isStrict) {
            factory.setFidelityOptions(FidelityOptions.createStrict());
        } else if (this.isDefault) {
            factory.setFidelityOptions(FidelityOptions.createDefault());
        } else {
            FidelityOptions options = factory.getFidelityOptions();
            options.setFidelity("PRESERVE_COMMENTS", this.preserveComments);
            options.setFidelity("PRESERVE_PIS", this.preserveProcessingInstructions);
            options.setFidelity("PRESERVE_DTDS", this.preserveDTD);
            options.setFidelity("PRESERVE_PREFIXES", this.preservePrefixes);
            options.setFidelity("PRESERVE_LEXICAL_VALUES", this.preserveLexicalValue);
        }
        factory.setCodingMode(this.alignment);
        return factory;
    }

    private Grammars getGrammars() {
        if (this.isSchemaLessGrammar()) {
            return this.grammarSchemaLess;
        }
        if (this.isXSBaseTypeGrammar()) {
            return this.grammarBaseTypes;
        }
        if (this.isSOS20Schema()) {
            return this.grammarSos20;
        }
        if (this.isSOS10Schema()) {
            return this.grammarSos10;
        }
        return this.grammarSchemaLess;
    }

    private boolean isSchemaLessGrammar() {
        return this.isSchemaLessGrammar;
    }

    private void setSchemaLessGrammar(boolean isSchemaLessGrammar) {
        this.isSchemaLessGrammar = isSchemaLessGrammar;
    }

    public boolean isXSBaseTypeGrammar() {
        return this.isXSBaseTypeGrammar;
    }

    public void setXSBaseTypeGrammar(boolean isXSBaseTypeGrammar) {
        this.isXSBaseTypeGrammar = isXSBaseTypeGrammar;
    }

    public boolean isSOS20Schema() {
        return this.isSOS20Schema;
    }

    public void setSOS20Schema(boolean isSOS20Schema) {
        this.isSOS20Schema = isSOS20Schema;
    }

    public boolean isSOS10Schema() {
        return this.isSOS10Schema;
    }

    public void setSOS10Schema(boolean isSOS10Schema) {
        this.isSOS10Schema = isSOS10Schema;
    }
}

