/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.n52.faroe.ConfigurationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractPropertyFileHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPropertyFileHandler.class);
    private static final String ERROR_READING_MESSAGE = "Error reading properties";
    private static final String ERROR_WRITING_MESSAGE = "Error writing properties";
    private final File propertiesFile;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Properties cache;

    protected AbstractPropertyFileHandler(String name) {
        this.propertiesFile = new File(name);
    }

    public AbstractPropertyFileHandler(File file) {
        this.propertiesFile = file;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="false positive")
    protected Properties load() throws IOException {
        if (this.cache == null) {
            File f = this.getFile(false);
            if (f == null) {
                return new Properties();
            }
            try (FileInputStream is = new FileInputStream(f);){
                Properties p = new Properties();
                p.load(is);
                this.cache = p;
            }
        }
        return this.cache;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="false positive")
    protected void save(Properties p) throws IOException {
        try (FileOutputStream os = new FileOutputStream(this.getFile(true));){
            p.store(os, null);
            this.cache = p;
        }
    }

    public void save(String m, String value) throws ConfigurationError {
        this.lock.writeLock().lock();
        try {
            Properties p = this.load();
            p.setProperty(m, value);
            this.save(p);
        }
        catch (IOException e) {
            throw new ConfigurationError(ERROR_WRITING_MESSAGE, (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void setCache(Properties p) {
        this.cache = p;
    }

    protected Properties getCache() {
        return this.cache;
    }

    public File getFile(boolean create) throws IOException {
        if (this.propertiesFile.exists() || create && this.propertiesFile.createNewFile()) {
            return this.propertiesFile;
        }
        return null;
    }

    public String get(String m) throws ConfigurationError {
        this.lock.readLock().lock();
        try {
            String string = this.load().getProperty(m);
            return string;
        }
        catch (IOException e) {
            throw new ConfigurationError(ERROR_READING_MESSAGE, (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void delete(String m) throws ConfigurationError {
        this.lock.writeLock().lock();
        try {
            Properties p = this.load();
            p.remove(m);
            this.save(p);
        }
        catch (IOException e) {
            throw new ConfigurationError(ERROR_WRITING_MESSAGE, (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean delete() {
        try {
            this.cache = null;
            LOG.debug("Removing properties file: {}.", (Object)this.getFile(false));
            return this.exists() ? this.getFile(false).delete() : true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void saveAll(Properties properties) throws ConfigurationError {
        this.lock.writeLock().lock();
        try {
            Properties p = this.load();
            AbstractPropertyFileHandler.copyTo(properties, p);
            this.save(p);
        }
        catch (IOException e) {
            throw new ConfigurationError(ERROR_WRITING_MESSAGE, (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Properties getAll() throws ConfigurationError {
        this.lock.readLock().lock();
        try {
            Properties properties = AbstractPropertyFileHandler.copyOf(this.load());
            return properties;
        }
        catch (IOException e) {
            throw new ConfigurationError(ERROR_READING_MESSAGE, (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getPath() {
        return this.propertiesFile.getAbsolutePath();
    }

    public boolean exists() {
        try {
            return this.getFile(false) != null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void copyTo(Properties source, Properties target) {
        source.stringPropertyNames().forEach(key -> target.setProperty((String)key, source.getProperty((String)key)));
    }

    private static Properties copyOf(Properties p) {
        Properties np = new Properties();
        AbstractPropertyFileHandler.copyTo(p, np);
        return np;
    }
}

