/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.ogc.ows;

import com.google.common.base.Splitter;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.util.LocalizedLazyThreadSafeProducer;
import org.n52.shetland.ogc.ows.OwsAddress;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.OwsContact;
import org.n52.shetland.ogc.ows.OwsOnlineResource;
import org.n52.shetland.ogc.ows.OwsPhone;
import org.n52.shetland.ogc.ows.OwsResponsibleParty;
import org.n52.shetland.ogc.ows.OwsServiceProvider;

@Configurable
public class OwsServiceProviderFactory
extends LocalizedLazyThreadSafeProducer<OwsServiceProvider> {
    private String name;
    private URI site;
    private String individualName;
    private String positionName;
    private String phone;
    private String deliveryPoint;
    private String city;
    private String postalCode;
    private String country;
    private String electronicMailAddress;
    private String administrativeArea;
    private String facsimile;
    private String hoursOfService;
    private String contactInstructions;
    private String onlineResoureTitle;
    private URI onlineResoureHref;
    private String role;
    private URI roleCodespace;

    @Setting(value="serviceProvider.name")
    public void setName(String name) throws ConfigurationError {
        this.name = name;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.site")
    public void setSite(URI site) {
        this.site = site;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.individualName")
    public void setIndividualName(String individualName) {
        this.individualName = individualName;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.positionName")
    public void setPositionName(String positionName) {
        this.positionName = positionName;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.phone")
    public void setPhone(String phone) {
        this.phone = phone;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.facsimile")
    public void setFacsimile(String facsimile) {
        this.facsimile = facsimile;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.address")
    public void setDeliveryPoint(String deliveryPoint) {
        this.deliveryPoint = deliveryPoint;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.city")
    public void setCity(String city) {
        this.city = city;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.postalCode")
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.country")
    public void setCountry(String country) {
        this.country = country;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.email")
    public void setMailAddress(String mailAddress) {
        this.electronicMailAddress = mailAddress;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.state")
    public void setAdministrativeArea(String administrativeArea) {
        this.administrativeArea = administrativeArea;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.hoursOfService")
    public void setHours(String hours) {
        this.hoursOfService = hours;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.contactInstructions")
    public void setContactInstructions(String contactInstructions) {
        this.contactInstructions = contactInstructions;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.onlineResource")
    public void setOnlineResource(String onlineResource) {
        if (Optional.ofNullable(onlineResource).isPresent()) {
            Iterable split = Splitter.on((String)"|").trimResults().split((CharSequence)onlineResource);
            Iterator iterator = split.iterator();
            this.onlineResoureTitle = (String)iterator.next();
            this.onlineResoureHref = URI.create((String)iterator.next());
            this.setRecreate();
        }
    }

    @Setting(value="serviceProvider.role.value")
    public void setRole(String role) {
        this.role = role;
        this.setRecreate();
    }

    @Setting(value="serviceProvider.role.codespace")
    public void setRoleCodespace(URI roleCodespace) {
        this.roleCodespace = roleCodespace;
        this.setRecreate();
    }

    @Override
    protected OwsServiceProvider create(Locale language) throws ConfigurationError {
        String organisationName = null;
        OwsOnlineResource onlineResource = null;
        if (this.site != null) {
            onlineResource = new OwsOnlineResource(this.site);
        }
        OwsCode roleCode = null;
        if (this.role != null) {
            roleCode = new OwsCode(this.role, this.roleCodespace);
        }
        OwsOnlineResource providerSite = null;
        if (this.onlineResoureHref != null) {
            providerSite = new OwsOnlineResource(this.onlineResoureHref, this.onlineResoureTitle);
        }
        OwsAddress address = null;
        if (OwsServiceProviderFactory.anyNonNull(this.deliveryPoint, this.city, this.administrativeArea, this.postalCode, this.country, this.electronicMailAddress)) {
            address = new OwsAddress(this.deliveryPoint, this.city, this.administrativeArea, this.postalCode, this.country, this.electronicMailAddress);
        }
        OwsPhone owsPhone = null;
        if (OwsServiceProviderFactory.anyNonNull(this.phone, this.facsimile)) {
            owsPhone = new OwsPhone(this.phone, this.facsimile);
        }
        OwsContact contactInfo = null;
        if (OwsServiceProviderFactory.anyNonNull(owsPhone, address, onlineResource, this.hoursOfService, this.contactInstructions)) {
            contactInfo = new OwsContact(owsPhone, address, onlineResource, this.hoursOfService, this.contactInstructions);
        }
        OwsResponsibleParty serviceContact = new OwsResponsibleParty(this.individualName, organisationName, this.positionName, contactInfo, roleCode);
        return new OwsServiceProvider(this.name, providerSite, serviceContact);
    }

    @Override
    public Set<Locale> getAvailableLocales() {
        return Collections.emptySet();
    }

    private static boolean anyNonNull(Object ... values) {
        return Arrays.stream(values).anyMatch(Objects::nonNull);
    }
}

