/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.config.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.binding.PathBindingKey;
import org.n52.iceland.config.ActivationDao;
import org.n52.iceland.config.json.AbstractJsonActivationDao;
import org.n52.iceland.ogc.ows.extension.OwsOperationMetadataExtensionProviderKey;
import org.n52.iceland.request.operator.RequestOperatorKey;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;

public class JsonActivationDao
extends AbstractJsonActivationDao
implements ActivationDao {
    @Override
    public boolean isRequestOperatorActive(RequestOperatorKey key) {
        return this.isActive("operations", this.matches(key), key.isDefaultActive());
    }

    @Override
    public void setOperationStatus(RequestOperatorKey key, boolean active) {
        this.setStatus("operations", this.matches(key), s -> this.encode((Supplier<ObjectNode>)s, key), active);
    }

    @Override
    public Set<RequestOperatorKey> getRequestOperatorKeys() {
        return this.getKeys("operations", this::decodeRequestOperatorKey);
    }

    @Override
    public boolean isBindingActive(BindingKey key) {
        this.readLock().lock();
        try {
            boolean bl = this.getConfiguration().path("activation").path("bindings").path(key.getKeyAsString()).asBoolean(true);
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBindingStatus(BindingKey key, boolean active) {
        this.writeLock().lock();
        try {
            ObjectNode node = this.getConfiguration().with("activation").with("bindings");
            if (key instanceof PathBindingKey) {
                node = node.with("byPath");
            } else if (key instanceof MediaTypeBindingKey) {
                node = node.with("byMediaType");
            }
            node.put(key.getKeyAsString(), active);
        }
        finally {
            this.writeLock().unlock();
        }
        this.configuration().scheduleWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BindingKey> getBindingKeys() {
        this.readLock().lock();
        try {
            JsonNode node = this.getConfiguration().path("activation").path("bindings");
            HashSet<BindingKey> keys = new HashSet<BindingKey>(node.size());
            node.path("byPath").fieldNames().forEachRemaining(k -> keys.add(new PathBindingKey((String)k)));
            node.path("byMediaType").fieldNames().forEachRemaining(k -> keys.add(new MediaTypeBindingKey(MediaType.parse((String)k))));
            HashSet<BindingKey> hashSet = keys;
            return hashSet;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public boolean isOwsOperationMetadataExtensionProviderActive(OwsOperationMetadataExtensionProviderKey key) {
        return this.isActive("owsExtendedCapabilitiesProviders", this.matches(key), true);
    }

    @Override
    public void setOwsOperationMetadataExtensionProviderStatus(OwsOperationMetadataExtensionProviderKey key, boolean active) {
        this.setStatus("owsExtendedCapabilitiesProviders", this.matches(key), s -> this.encode((Supplier<ObjectNode>)s, key), active);
    }

    @Override
    public Set<OwsOperationMetadataExtensionProviderKey> getOwsOperationMetadataExtensionProviderKeys() {
        return this.getKeys("owsExtendedCapabilitiesProviders", this.decodeOwsExtendedCapabilitiesProviderKey());
    }

    protected RequestOperatorKey decodeRequestOperatorKey(JsonNode node) {
        return new RequestOperatorKey(this.decodeServiceOperatorKey(node), node.path("operationName").textValue());
    }

    protected Function<JsonNode, OwsOperationMetadataExtensionProviderKey> decodeOwsExtendedCapabilitiesProviderKey() {
        return this.createDomainDecoder(OwsOperationMetadataExtensionProviderKey::new);
    }

    protected Supplier<ObjectNode> encode(Supplier<ObjectNode> supplier, RequestOperatorKey key) {
        Objects.requireNonNull(supplier);
        return () -> {
            OwsServiceKey sok = key == null ? null : key.getServiceOperatorKey();
            String operationName = key == null ? null : key.getOperationName();
            return this.encode(supplier, sok).get().put("operationName", operationName);
        };
    }

    protected Predicate<JsonNode> matches(RequestOperatorKey key) {
        OwsServiceKey sok = key == null ? null : key.getServiceOperatorKey();
        String operationName = key == null ? null : key.getOperationName();
        return this.matches(sok).and(this.matchesOperationName(operationName));
    }

    protected Predicate<JsonNode> matchesOperationName(String operationName) {
        if (operationName == null) {
            return this.isNullOrMissing("operationName");
        }
        return n -> n.path("operationName").asText().equals(operationName);
    }
}

