/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding.kvp;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.binding.BindingKey;
import org.n52.iceland.binding.MediaTypeBindingKey;
import org.n52.iceland.binding.SimpleBinding;
import org.n52.iceland.coding.decode.OwsDecodingException;
import org.n52.iceland.exception.HTTPException;
import org.n52.iceland.exception.ows.concrete.InvalidServiceParameterException;
import org.n52.iceland.exception.ows.concrete.MissingRequestParameterException;
import org.n52.iceland.exception.ows.concrete.VersionNotSupportedException;
import org.n52.janmayen.exception.CompositeException;
import org.n52.janmayen.exception.LocationHintException;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.janmayen.stream.Streams;
import org.n52.shetland.ogc.ows.OWSConstants;
import org.n52.shetland.ogc.ows.exception.CompositeOwsException;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.MissingServiceParameterException;
import org.n52.shetland.ogc.ows.exception.OperationNotSupportedException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.OperationDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public class KvpBinding
extends SimpleBinding {
    private static final Logger LOGGER = LoggerFactory.getLogger(KvpBinding.class);
    @Deprecated
    private static final Set<String> CONFORMANCE_CLASSES = Collections.singleton("http://www.opengis.net/spec/SOS/2.0/conf/kvp-core");
    private static final Set<BindingKey> KEYS = Collections.singleton(new MediaTypeBindingKey(MediaTypes.APPLICATION_KVP));
    private boolean useHttpResponseCodes;
    private boolean includeOriginalRequest;

    @Setting(value="misc.httpResponseCodeUseInKvpAndPoxBinding")
    public void setUseHttpResponseCodes(boolean useHttpResponseCodes) {
        this.useHttpResponseCodes = useHttpResponseCodes;
    }

    @Override
    protected boolean isUseHttpResponseCodes() {
        return this.useHttpResponseCodes;
    }

    @Setting(value="misc.includeOriginalRequest")
    public void setIncludeOriginalRequest(boolean includeOriginalRequest) {
        this.includeOriginalRequest = includeOriginalRequest;
    }

    public Set<BindingKey> getKeys() {
        return Collections.unmodifiableSet(KEYS);
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    @Override
    protected MediaType getDefaultContentType() {
        return MediaTypes.APPLICATION_XML;
    }

    @Override
    public void doGetOperation(HttpServletRequest req, HttpServletResponse res) throws HTTPException, IOException {
        LOGGER.debug("KVP-REQUEST: {}", (Object)req.getQueryString());
        OwsServiceRequest serviceRequest = null;
        try {
            serviceRequest = this.parseRequest(req);
            serviceRequest.setRequestContext(this.getRequestContext(req));
            OwsServiceResponse response = this.getServiceOperator(serviceRequest).receiveRequest(serviceRequest);
            this.writeResponse(req, res, response);
        }
        catch (OwsExceptionReport oer) {
            oer.setVersion(serviceRequest != null ? serviceRequest.getVersion() : null);
            this.writeOwsExceptionReport(req, res, oer);
        }
    }

    @Override
    public boolean checkOperationHttpGetSupported(OwsOperationKey k) {
        return this.hasDecoder(k, MediaTypes.APPLICATION_KVP);
    }

    protected OwsServiceRequest parseRequest(HttpServletRequest req) throws OwsExceptionReport {
        OwsServiceRequest request;
        if (req.getParameterMap() == null || req.getParameterMap().isEmpty()) {
            throw new MissingRequestParameterException();
        }
        Map<String, String> parameters = Streams.stream((Enumeration)req.getParameterNames()).collect(Collectors.toMap(name -> name.replace("amp;", "").toLowerCase(Locale.ROOT), arg_0 -> ((HttpServletRequest)req).getParameter(arg_0)));
        String service = parameters.get(OWSConstants.RequestParams.service.name());
        String version = parameters.get(OWSConstants.RequestParams.version.name());
        String operation = parameters.get(OWSConstants.RequestParams.request.name());
        if (Strings.isNullOrEmpty((String)service)) {
            throw new MissingServiceParameterException();
        }
        if (!this.isServiceSupported(service)) {
            throw new InvalidServiceParameterException(service);
        }
        if (Strings.isNullOrEmpty((String)operation)) {
            throw new MissingRequestParameterException();
        }
        if (version != null && !this.isVersionSupported(service, version)) {
            throw new VersionNotSupportedException();
        }
        Decoder decoder = this.getDecoder((DecoderKey)new OperationDecoderKey(service, version, operation, MediaTypes.APPLICATION_KVP));
        if (decoder == null) {
            throw new OperationNotSupportedException(operation);
        }
        try {
            request = (OwsServiceRequest)decoder.decode(parameters);
        }
        catch (OwsDecodingException ex) {
            throw ex.getCause();
        }
        catch (DecodingException ex) {
            throw this.toOwsExceptionReport(ex);
        }
        if (this.includeOriginalRequest) {
            request.setOriginalRequest(String.join((CharSequence)"?", req.getRequestURL(), req.getQueryString()));
        }
        return request;
    }

    private OwsExceptionReport toOwsExceptionReport(CompositeException ex) {
        return (OwsExceptionReport)ex.getExceptions().stream().map(this::toOwsExceptionReport).collect(Collector.of(CompositeOwsException::new, (rec$, xva$0) -> ((CompositeOwsException)rec$).add(new OwsExceptionReport[]{xva$0}), CompositeOwsException::addAllOf, new Collector.Characteristics[0]));
    }

    private OwsExceptionReport toOwsExceptionReport(Throwable ex) {
        if (ex instanceof OwsExceptionReport) {
            return (OwsExceptionReport)ex;
        }
        Throwable cause = ex.getCause();
        if (cause instanceof OwsExceptionReport) {
            return (OwsExceptionReport)cause;
        }
        if (ex instanceof CompositeException) {
            return this.toOwsExceptionReport((CompositeException)ex);
        }
        if (cause instanceof CompositeException) {
            return this.toOwsExceptionReport((CompositeException)cause);
        }
        String location = null;
        if (ex instanceof LocationHintException) {
            location = ((LocationHintException)ex).getLocation().orElse(null);
        } else if (cause instanceof LocationHintException) {
            location = ((LocationHintException)cause).getLocation().orElse(null);
        }
        return new InvalidParameterValueException().withMessage(ex.getMessage(), new Object[0]).causedBy(ex).at(location);
    }
}

