/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.n52.iceland.util.NonNegativeBigInteger;
import org.n52.iceland.util.PositiveBigInteger;

public class ValidatableBigIntegers {
    @Test
    public void validPositive() {
        PositiveBigInteger pbi = new PositiveBigInteger("52");
        Assert.assertThat((Object)pbi.intValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)52)));
    }

    @Test
    public void validNonNegative() {
        NonNegativeBigInteger nnbi = new NonNegativeBigInteger("52");
        Assert.assertThat((Object)nnbi.intValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)52)));
        nnbi = new NonNegativeBigInteger("0");
        Assert.assertThat((Object)nnbi.intValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void validNonNegativeZero() {
        NonNegativeBigInteger nnbi = new NonNegativeBigInteger("0");
        Assert.assertThat((Object)nnbi.intValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidPositive() {
        PositiveBigInteger pbi = new PositiveBigInteger("-1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidPositiveZero() {
        PositiveBigInteger pbi = new PositiveBigInteger("0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidNonNegative() {
        NonNegativeBigInteger nnbi = new NonNegativeBigInteger("-1");
    }
}

